/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.arthas.domain.model.AtinInsurerCity;
import com.zhlh.arthas.mapper.AtinInsurerCityMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.InsuComCityService;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.zeus.api.InsureCityRService;
import com.zhlh.zeus.dto.insureCity.InsurerCity;
import com.zhlh.zeus.dto.insureCity.InsurerCityResDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsuComCityServiceImpl
extends BaseServiceImpl<AtinInsurerCity>
implements InsuComCityService {
    @Autowired
    private AtinInsurerCityMapper mapper;
    @Autowired
    private InsureCityRService insureCityRService;

    @Override
    public BaseMapper<AtinInsurerCity> getBaseMapper() {
        return this.mapper;
    }

    @Override
    public void syncInsuComCity() {
        InsurerCityResDto insurerCityResDto = this.insureCityRService.getAllInsurerCityList();
        if (0 != insurerCityResDto.getErrCode()) {
            return;
        }
        List insuComCityList = this.mapper.getAll(null);
        HashMap<String, AtinInsurerCity> insuComCityMap = new HashMap<String, AtinInsurerCity>();
        for (AtinInsurerCity insuComCity : insuComCityList) {
            insuComCityMap.put(insuComCity.getCityCode() + "_" + insuComCity.getInsuCom(), insuComCity);
        }
        ArrayList<AtinInsurerCity> insertList = new ArrayList<AtinInsurerCity>();
        ArrayList<AtinInsurerCity> updateList = new ArrayList<AtinInsurerCity>();
        for (InsurerCity insurerCity : insurerCityResDto.getInsurerCityList()) {
            String key = insurerCity.getCityCode() + "_" + insurerCity.getInsuCom();
            AtinInsurerCity insuComCity = (AtinInsurerCity)insuComCityMap.get(key);
            if (insuComCity == null) {
                AtinInsurerCity insertInsuComCity = new AtinInsurerCity();
                BeanUtil.quickCopy((Object)insurerCity, (Object)insertInsuComCity);
                insertInsuComCity.setIsAccess(Integer.valueOf(1));
                insertInsuComCity.setDiscount(new BigDecimal("0.00"));
                insertList.add(insertInsuComCity);
            } else {
                BeanUtil.quickCopy((Object)insurerCity, (Object)insuComCity);
                insuComCity.setIsAccess(Integer.valueOf(1));
                updateList.add(insuComCity);
            }
            insuComCityMap.remove(key);
        }
        if (insuComCityMap.size() > 0) {
            for (String key : insuComCityMap.keySet()) {
                AtinInsurerCity insuComCity = (AtinInsurerCity)insuComCityMap.get(key);
                insuComCity.setIsAccess(Integer.valueOf(0));
                updateList.add(insuComCity);
            }
        }
        if (!CommonUtil.isEmpty(insertList)) {
            this.mapper.batchInsert(insertList);
        }
        if (!CommonUtil.isEmpty(updateList)) {
            this.mapper.batchUpdate(updateList);
        }
    }
}

