/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.impl.atin;

import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.exception.CommonException;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.Tiny.util.NumberUtil;
import com.zhlh.arthas.domain.dto.atin.api.CoverageResDto;
import com.zhlh.arthas.domain.dto.atin.api.JsonIdentityCollectReqDto;
import com.zhlh.arthas.domain.dto.atin.api.JsonIdentityCollectResDto;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.AtinOrderRoles;
import com.zhlh.arthas.domain.model.AtinPolicy;
import com.zhlh.arthas.domain.model.AtinPolicyCoverage;
import com.zhlh.arthas.mapper.AtinOrderMapper;
import com.zhlh.arthas.mapper.AtinPolicyCoverageMapper;
import com.zhlh.arthas.mapper.AtinPolicyMapper;
import com.zhlh.arthas.mapper.BaseMapper;
import com.zhlh.arthas.service.IdentityCollectService;
import com.zhlh.arthas.service.QuotationService;
import com.zhlh.arthas.service.common.ServiceUtil;
import com.zhlh.arthas.service.impl.BaseServiceImpl;
import com.zhlh.arthas.util.ErrorMessageUtil;
import com.zhlh.zeus.api.IdentityCollectRService;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectReqDto;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectResDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdentityCollectServiceImpl
extends BaseServiceImpl<AtinPolicy>
implements IdentityCollectService {
    private static final Logger log = LoggerFactory.getLogger(IdentityCollectServiceImpl.class);
    @Autowired
    private IdentityCollectRService identityCollectRService;
    @Autowired
    private QuotationService quotationService;
    @Autowired
    private AtinOrderMapper atinOrderMapper;
    @Autowired
    private AtinPolicyMapper atinPolicyMapper;
    @Autowired
    private AtinPolicyCoverageMapper atinPolicyCoverageMapper;

    @Override
    public BaseMapper<AtinPolicy> getBaseMapper() {
        return this.atinPolicyMapper;
    }

    @Override
    public JsonIdentityCollectResDto identityCollect(String jsonParam, String originCode) {
        Integer orderId;
        JSONObject jsonObject = JsonUtil.getJSONObject((String)jsonParam);
        JsonIdentityCollectResDto jsonIdentityCollectResDto = new JsonIdentityCollectResDto();
        AtinOrderRoles orderRoles = new AtinOrderRoles();
        try {
            orderRoles = this.getAtinOrderRoles(jsonParam, orderRoles);
            orderId = this.quotationService.preciseQuotePrice(orderRoles, jsonObject.getString("quoteNo"), originCode);
        }
        catch (CommonException e) {
            throw new CommonException(e.getCode().intValue(), ErrorMessageUtil.errorConvert(e.getCode(), e.getMessage()));
        }
        AtinOrder atinOrder = (AtinOrder)this.atinOrderMapper.selectByPrimaryKey(orderId);
        jsonIdentityCollectResDto.setOrderSn(atinOrder.getOrderSn());
        AtinPolicy atinPolicy = (AtinPolicy)this.atinPolicyMapper.selectByPrimaryKey(atinOrder.getPolicyId());
        List atinPolicyCoverageList = this.atinPolicyCoverageMapper.getCoverageList(atinOrder.getPolicyId());
        ArrayList<CoverageResDto> coverages = new ArrayList<CoverageResDto>();
        for (AtinPolicyCoverage atinPolicyCoverage : atinPolicyCoverageList) {
            CoverageResDto coverageDataDto = new CoverageResDto();
            BeanUtil.quickCopy((Object)atinPolicyCoverage, (Object)coverageDataDto);
            coverageDataDto.setIsDeductibleChoice(atinPolicyCoverage.getIsDeductibleChoice());
            coverageDataDto.setIsApprove(String.valueOf(atinPolicyCoverage.getIsApprove()));
            if (atinPolicyCoverage.getAmount() != null) {
                coverageDataDto.setAmount(NumberUtil.divide((String)String.valueOf(atinPolicyCoverage.getAmount()), (String)"100", (int)2));
            }
            if (atinPolicyCoverage.getUnimount().intValue() != 0) {
                coverageDataDto.setUnimount(NumberUtil.divide((String)String.valueOf(atinPolicyCoverage.getUnimount()), (String)"100", (int)2));
            }
            if (atinPolicyCoverage.getPremium().intValue() != 0) {
                coverageDataDto.setPremium(NumberUtil.divide((String)String.valueOf(atinPolicyCoverage.getPremium()), (String)"100", (int)2));
            }
            coverages.add(coverageDataDto);
        }
        jsonIdentityCollectResDto.setCoverages(coverages);
        BeanUtil.adviceCopy((Object)atinPolicy, (Object)jsonIdentityCollectResDto);
        jsonIdentityCollectResDto = this.getJsonIdentityCollectResDto(atinPolicy, jsonIdentityCollectResDto);
        IdentityCollectReqDto identityCollectReqDto = new IdentityCollectReqDto();
        identityCollectReqDto = this.identityCollectReqDto(identityCollectReqDto, jsonParam);
        identityCollectReqDto = this.getJsonIdentityCollectReqDto(orderRoles, identityCollectReqDto, atinPolicy.getLicenseNo());
        if (ServiceUtil.isBJVehicle(atinPolicy.getLicenseNo())) {
            identityCollectReqDto.setPartner("zhlh");
            identityCollectReqDto.setInsuCom(atinPolicy.getInsuCom());
            identityCollectReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(atinPolicy.getLicenseNo()));
            IdentityCollectResDto identityCollectResDto = this.identityCollectRService.identityCollect(identityCollectReqDto);
            if (identityCollectResDto.getErrCode() == 3000) {
                throw new CommonException(identityCollectResDto.getErrCode().intValue(), ErrorMessageUtil.errorConvert(identityCollectResDto.getErrCode(), identityCollectResDto.getErrMsg()));
            }
        }
        log.info("jsonIdentityCollectResDto.getPremium()" + jsonIdentityCollectResDto.getPremium());
        if (CommonUtil.isNotEmpty((String)jsonIdentityCollectResDto.getPremium())) {
            jsonIdentityCollectResDto.setPremium(NumberUtil.divide((String)jsonIdentityCollectResDto.getPremium(), (String)"100", (int)2));
        }
        if (CommonUtil.isNotEmpty((String)jsonIdentityCollectResDto.getVciPremium())) {
            jsonIdentityCollectResDto.setVciPremium(NumberUtil.divide((String)jsonIdentityCollectResDto.getVciPremium(), (String)"100", (int)2));
        }
        if (CommonUtil.isNotEmpty((String)jsonIdentityCollectResDto.getTciPremium())) {
            jsonIdentityCollectResDto.setTciPremium(NumberUtil.divide((String)jsonIdentityCollectResDto.getTciPremium(), (String)"100", (int)2));
        }
        if (CommonUtil.isNotEmpty((String)jsonIdentityCollectResDto.getLuborPremium())) {
            jsonIdentityCollectResDto.setLuborPremium(NumberUtil.divide((String)jsonIdentityCollectResDto.getLuborPremium(), (String)"100", (int)2));
        }
        if (CommonUtil.isNotEmpty((String)jsonIdentityCollectResDto.getSumTravelTax())) {
            jsonIdentityCollectResDto.setSumTravelTax(NumberUtil.divide((String)jsonIdentityCollectResDto.getSumTravelTax(), (String)"100", (int)2));
        }
        return jsonIdentityCollectResDto;
    }

    private AtinOrderRoles getAtinOrderRoles(String jsonParam, AtinOrderRoles orderRoles) {
        JsonIdentityCollectReqDto jsonIdentityCollectReqDto = (JsonIdentityCollectReqDto)JsonUtil.jsonToBean((String)jsonParam, JsonIdentityCollectReqDto.class);
        BeanUtil.quickCopy((Object)jsonIdentityCollectReqDto, (Object)orderRoles);
        return orderRoles;
    }

    private IdentityCollectReqDto getJsonIdentityCollectReqDto(AtinOrderRoles orderRoles, IdentityCollectReqDto identityCollectReqDto, String queryNo) {
        identityCollectReqDto.setCertNo(orderRoles.getApplicantCertNo());
        identityCollectReqDto.setName(orderRoles.getApplicantName());
        identityCollectReqDto.setMobile(orderRoles.getApplicantMobile());
        return identityCollectReqDto;
    }

    private JsonIdentityCollectResDto getJsonIdentityCollectResDto(AtinPolicy atinPolicy, JsonIdentityCollectResDto jsonIdentityCollectResDto) {
        jsonIdentityCollectResDto.setQuoteNo(atinPolicy.getQueryNo());
        jsonIdentityCollectResDto.setOriginDiscount(atinPolicy.getLuborDiscount().toString());
        return jsonIdentityCollectResDto;
    }

    public IdentityCollectReqDto identityCollectReqDto(IdentityCollectReqDto identityCollectReqDto, String jsonParam) {
        JsonIdentityCollectReqDto jsonIdentityCollectReqDto = (JsonIdentityCollectReqDto)JsonUtil.jsonToBean((String)jsonParam, JsonIdentityCollectReqDto.class);
        BeanUtil.quickCopy((Object)jsonIdentityCollectReqDto, (Object)identityCollectReqDto);
        identityCollectReqDto.setChannel("Arthas");
        return identityCollectReqDto;
    }
}

