/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.common;

import com.zhlh.Tiny.util.CityLicense;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.Tiny.util.Md5Util;
import com.zhlh.Tiny.util.RedisUtil;
import com.zhlh.Tiny.util.RegexUtil;
import com.zhlh.arthas.domain.dto.atin.QuotePriceResultDto;
import com.zhlh.arthas.domain.model.AtinCoverage;
import com.zhlh.arthas.domain.model.AtinInsurer;
import com.zhlh.arthas.domain.model.AtinInsurerCity;
import com.zhlh.arthas.domain.model.AtinOriginCity;
import com.zhlh.arthas.domain.model.OpenInterface;
import com.zhlh.arthas.service.common.ServiceCache;
import com.zhlh.zeus.dto.quote.CoverageDataDto;
import com.zhlh.zeus.dto.quote.QuotePriceReqDto;
import com.zhlh.zeus.dto.quote.QuotePriceResDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ServiceUtil {
    private static Integer addNum = 0;

    public static Integer convertAmountInt(String str) {
        if (CommonUtil.isNotEmpty((String)str) && str.contains("\u4e07")) {
            str = str.substring(0, str.length() - 1);
            Integer amount = new Integer(str);
            amount = amount * 10000;
            return amount;
        }
        return 0;
    }

    public static AtinCoverage getCoverageByCode(String coverageCode) {
        Map coverageMap = (Map)ServiceCache.SERVICE_CACHE.get("coverage");
        return (AtinCoverage)coverageMap.get(coverageCode);
    }

    public static AtinInsurer getInsurerByCode(String insurerCode) {
        Map insurerMap = (Map)ServiceCache.SERVICE_CACHE.get("insurer");
        return (AtinInsurer)insurerMap.get(insurerCode);
    }

    public static Set<String> getAllInterfaceUrl(String type) {
        Map mapMap = (Map)ServiceCache.SERVICE_CACHE.get("open_interface");
        return ((Map)mapMap.get(type)).keySet();
    }

    public static OpenInterface getInterfaceByPath(String path, String type) {
        Map mapMap = (Map)ServiceCache.SERVICE_CACHE.get("open_interface");
        return (OpenInterface)((Map)mapMap.get(type)).get(path);
    }

    public static String getCityCodeByLicenseNo(String licenseNo) {
        String cityCode = CityLicense.getCityCodeByLicense((String)licenseNo);
        return CommonUtil.isEmpty((String)cityCode) ? "" : cityCode;
    }

    public static List<AtinInsurerCity> getSupportInsurerCity(String licenseNo, String originCode) {
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insurer_city");
        System.out.println(licenseNo + " " + originCode + " " + insuComCityListMap.size());
        String shortLicenseNo = licenseNo.substring(0, 2);
        List atinInsurerCityList = (List)insuComCityListMap.get(shortLicenseNo);
        if (CommonUtil.isEmpty((Collection)atinInsurerCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            atinInsurerCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        atinInsurerCityList = atinInsurerCityList == null ? new ArrayList() : atinInsurerCityList;
        Map atinOriginCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("origin_city");
        List atinOriginCityList = (List)atinOriginCityListMap.get(originCode);
        ArrayList<String> originCityStrList = new ArrayList<String>();
        for (AtinOriginCity atinOriginCity : atinOriginCityList) {
            originCityStrList.add(atinOriginCity.getCityCode());
        }
        for (int i = 0; i < atinInsurerCityList.size(); ++i) {
            AtinInsurerCity atinInsurerCity = (AtinInsurerCity)atinInsurerCityList.get(i);
            if (originCityStrList.contains(atinInsurerCity.getCityCode())) continue;
            atinInsurerCityList.remove(atinInsurerCity);
            --i;
        }
        return atinInsurerCityList;
    }

    public static Boolean isSupportByInsurerCode(String insurerCode, String licenseNo, String originCode) {
        List<AtinInsurerCity> atinInsurerCityList = ServiceUtil.getSupportInsurerCity(licenseNo, originCode);
        for (AtinInsurerCity insurerCity : atinInsurerCityList) {
            if (!insurerCity.getInsuCom().equals(insurerCode)) continue;
            return true;
        }
        return false;
    }

    public static BigDecimal getLuborDiscount(String insurerCode, String licenseNo, String originCode) {
        String cityCode = ServiceUtil.getCityCodeByLicenseNo(licenseNo);
        Map atinOriginCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("origin_city");
        List atinOriginCityList = (List)atinOriginCityListMap.get(originCode);
        for (AtinOriginCity atinOriginCity : atinOriginCityList) {
            if (!insurerCode.equals(atinOriginCity.getInsuCom()) || !cityCode.equals(atinOriginCity.getCityCode())) continue;
            return atinOriginCity.getDiscount();
        }
        return new BigDecimal("0");
    }

    public static BigDecimal getMarketPremium(String insurerCode, String licenseNo, BigDecimal premium) {
        String shortLicenseNo;
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insurer_city");
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo = licenseNo.substring(0, 2));
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        for (AtinInsurerCity insuComCity : insuComCityList) {
            if (!insurerCode.equals(insuComCity.getInsuCom())) continue;
            if (!"NetSales".equals(insuComCity.getType())) continue;
            return premium.divide(new BigDecimal(85), 2).multiply(new BigDecimal(100));
        }
        return premium;
    }

    public static boolean isBJVehicle(String licenseNo) {
        return licenseNo.startsWith("\u4eac");
    }

    public static String randomOrderSn() {
        String today = DateUtil.formatDate((Date)new Date(), (String)"yyMMdd");
        String second = String.valueOf(System.currentTimeMillis() / 1000L);
        String secondStr = second.substring(second.length() - 5);
        String num = ServiceUtil.getAddNum();
        return today + num + secondStr + ServiceUtil.getRandomNum();
    }

    private static synchronized String getAddNum() {
        addNum = addNum < 999 ? addNum + 1 : 0;
        return String.format("%03d", addNum);
    }

    private static String getRandomNum() {
        return String.format("%02d", new Random().nextInt(99));
    }

    public static BigDecimal getBigDecimal(String value) {
        if (!CommonUtil.isEmpty((String)value) && RegexUtil.checkDecimals((String)value)) {
            return new BigDecimal(value);
        }
        return new BigDecimal(0);
    }

    public static String convertAmount(String str) {
        if (CommonUtil.isNotEmpty((String)str) && str.contains("\u4e07")) {
            str = str.substring(0, str.length() - 1);
            Integer amount = new Integer(str);
            amount = amount * 10000;
            return String.valueOf(amount);
        }
        return str;
    }

    public static String formatStartDate(String startDate) {
        if (startDate.contains("/")) {
            Date date = DateUtil.parseDate((String)startDate, (String)"yyyy/MM/dd");
            startDate = DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd");
        }
        return startDate;
    }

    public static void saveQuoteReqDtoRedis(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        if (quotePriceReqDto != null) {
            quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(0));
            quotePriceReqDto.setActualValue(null);
            quotePriceReqDto.setTciDefaultStartDate(null);
            quotePriceReqDto.setVciDefaultStartDate(null);
            quotePriceReqDto.setOwnerData(null);
            quotePriceReqDto.setInsurantData(null);
            quotePriceReqDto.setPolicyHolderData(null);
            if (quotePriceReqDto.getCoverageDataDtoList() != null) {
                for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
                    if ("BZ,A,G1,X1,Z,M".contains(coverageDataDto.getCoverageCode()) && !"B".equals(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setAmount(null);
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setUnitAmount(null);
                        coverageDataDto.setModelCode(null);
                        coverageDataDto.setKindCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                        coverageDataDto.setDiscount(null);
                    }
                    if ("B,L".contains(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setUnitAmount(null);
                        coverageDataDto.setModelCode(null);
                        coverageDataDto.setKindCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                        coverageDataDto.setDiscount(null);
                    }
                    if ("D3,D4".contains(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setAmount(null);
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setModelCode(null);
                        coverageDataDto.setKindCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                        coverageDataDto.setDiscount(null);
                    }
                    if (!"F".contains(coverageDataDto.getCoverageCode())) continue;
                    coverageDataDto.setAmount(null);
                    coverageDataDto.setQuantity(null);
                    coverageDataDto.setKindCode(null);
                    coverageDataDto.setReason(null);
                    coverageDataDto.setBenchmarkPremium(null);
                    coverageDataDto.setPremium(null);
                    coverageDataDto.setDiscount(null);
                }
            }
        }
        RedisUtil.put((Serializable)((Object)"quotation"), (Serializable)((Object)("userId." + userId)), (Object)quotePriceReqDto);
    }

    public static QuotePriceReqDto getQuoteReqDtoFromRedis(Integer userId) {
        return (QuotePriceReqDto)RedisUtil.get((Serializable)((Object)"quotation"), (Serializable)((Object)("userId." + userId)), QuotePriceReqDto.class);
    }

    public static void resetQuoteResultDtoToRedis(Integer userId) {
        QuotePriceResultDto quotePriceResultDto = new QuotePriceResultDto();
        HashMap<String, QuotePriceResDto> resultMap = new HashMap<String, QuotePriceResDto>();
        quotePriceResultDto.setResultMap(resultMap);
        quotePriceResultDto.setQuoteQueryStr("");
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("userId." + userId)), (Object)quotePriceResultDto);
    }

    public static QuotePriceResultDto getQuoteResultDtoFromRedis(Integer userId) {
        return (QuotePriceResultDto)RedisUtil.get((Serializable)((Object)"quoteResult"), (Serializable)((Object)("userId." + userId)), QuotePriceResultDto.class);
    }

    public static void saveQuoteResultDtoToRedis(QuotePriceResultDto quotePriceResultDto, Integer userId) {
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("userId." + userId)), (Object)quotePriceResultDto);
    }

    public static void saveInsuComCodeToRedis(String insuComCode, Integer userId) {
        RedisUtil.put((Serializable)((Object)"insucomCode"), (Serializable)((Object)("userId." + userId)), (Object)insuComCode);
    }

    public static String getInsuComCodeFromRedis(Integer userId) {
        return (String)RedisUtil.get((Serializable)((Object)"insucomCode"), (Serializable)((Object)("userId." + userId)), String.class);
    }

    public static String getQuoteQueryStr(QuotePriceReqDto quotePriceReqDto) {
        String quoteQueryStr = JsonUtil.beanToJSON((Object)quotePriceReqDto);
        return Md5Util.md5AsLowerHex((String)quoteQueryStr);
    }

    public static BigDecimal getBigDic(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public static Integer getSortNum(String coverageCode) {
        switch (coverageCode) {
            case "BZ": {
                return 0;
            }
            case "A": {
                return 1;
            }
            case "B": {
                return 2;
            }
            case "G1": {
                return 3;
            }
            case "D3": {
                return 4;
            }
            case "D4": {
                return 5;
            }
            case "L": {
                return 6;
            }
            case "F": {
                return 7;
            }
            case "X1": {
                return 8;
            }
            case "Z": {
                return 9;
            }
            case "M": {
                return 10;
            }
        }
        return 11;
    }

    public static Integer getSortNumInsurer(String insurerCode) {
        switch (insurerCode) {
            case "I00002": {
                return 0;
            }
            case "I00001": {
                return 1;
            }
            case "I00027": {
                return 2;
            }
            case "I00004": {
                return 3;
            }
            case "I00019": {
                return 4;
            }
            case "I00003": {
                return 5;
            }
            case "I00009": {
                return 6;
            }
            case "I00028": {
                return 7;
            }
            case "I00008": {
                return 8;
            }
        }
        return 10;
    }
}

