/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.common;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.arthas.domain.model.AtinCoverage;
import com.zhlh.arthas.domain.model.AtinInsurer;
import com.zhlh.arthas.domain.model.AtinInsurerCity;
import com.zhlh.arthas.domain.model.AtinOriginCity;
import com.zhlh.arthas.domain.model.OpenInterface;
import com.zhlh.arthas.domain.model.Origin;
import com.zhlh.arthas.mapper.AtinCoverageMapper;
import com.zhlh.arthas.mapper.AtinInsurerCityMapper;
import com.zhlh.arthas.mapper.AtinInsurerMapper;
import com.zhlh.arthas.mapper.AtinOriginCityMapper;
import com.zhlh.arthas.mapper.OpenInterfaceMapper;
import com.zhlh.arthas.mapper.OriginMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceCache {
    private static final Logger log = LoggerFactory.getLogger(ServiceCache.class);
    public static Map<String, Object> SERVICE_CACHE;
    public static final String CACHE_COVERAGE_NAME = "coverage";
    public static final String CACHE_INSURER_NAME = "insurer";
    public static final String CACHE_INSURER_CITY_NAME = "insurer_city";
    public static final String CACHE_OPEN_INTERFACE_NAME = "open_interface";
    public static final String CACHE_ORIGIN_NAME = "origin";
    public static final String CACHE_ORIGIN_CITY_NAME = "origin_city";
    @Autowired
    private AtinCoverageMapper atinCoverageMapper;
    @Autowired
    private AtinInsurerMapper atinInsurerMapper;
    @Autowired
    private AtinInsurerCityMapper atinInsurerCityMapper;
    @Autowired
    private OpenInterfaceMapper openInterfaceMapper;
    @Autowired
    private AtinOriginCityMapper atinOriginCityMapper;
    @Autowired
    private OriginMapper originMapper;

    @PostConstruct
    public void initServiceCache() {
        SERVICE_CACHE = new HashMap<String, Object>();
        this.cacheCoverage();
        this.cacheInsurer();
        this.cacheInsurerCity();
        this.cacheOpenInterface();
        this.cacheOrigin();
        this.cacheOriginCity();
    }

    private void cacheOriginCity() {
        List atinOriginCityList = this.atinOriginCityMapper.getAll();
        HashMap<String, List> atinOriginCityListMap = new HashMap<String, List>();
        for (AtinOriginCity atinOriginCity : atinOriginCityList) {
            List cityList = (List)atinOriginCityListMap.get(atinOriginCity.getOriginCode());
            cityList = CommonUtil.isNotEmpty((Collection)cityList) ? cityList : new ArrayList();
            cityList.add(atinOriginCity);
            atinOriginCityListMap.put(atinOriginCity.getOriginCode(), cityList);
        }
        SERVICE_CACHE.put(CACHE_ORIGIN_CITY_NAME, atinOriginCityListMap);
        log.info("\u7f13\u5b58\u6e20\u9053\u5546\u5f00\u901a\u57ce\u5e02\u4fe1\u606f\u5b8c\u6bd5");
    }

    private void cacheOrigin() {
        List originList = this.originMapper.getAll();
        HashMap<String, Origin> originMap = new HashMap<String, Origin>();
        for (Origin origin : originList) {
            originMap.put(origin.getCode(), origin);
        }
        SERVICE_CACHE.put(CACHE_ORIGIN_NAME, originMap);
        log.info("\u7f13\u5b58\u6e20\u9053\u5546\u4fe1\u606f\u5b8c\u6bd5");
    }

    private void cacheOpenInterface() {
        List openInterfaceList = this.openInterfaceMapper.getAll();
        HashMap mapMap = new HashMap();
        HashMap<String, OpenInterface> h5OpenInterfaceMap = new HashMap<String, OpenInterface>();
        HashMap<String, OpenInterface> apiOpenInterfaceMap = new HashMap<String, OpenInterface>();
        for (OpenInterface openInterface : openInterfaceList) {
            if (openInterface.getType().equals("H5")) {
                h5OpenInterfaceMap.put(openInterface.getPath(), openInterface);
                continue;
            }
            if (!openInterface.getType().equals("API")) continue;
            apiOpenInterfaceMap.put(openInterface.getPath(), openInterface);
        }
        mapMap.put("H5", h5OpenInterfaceMap);
        mapMap.put("API", apiOpenInterfaceMap);
        SERVICE_CACHE.put(CACHE_OPEN_INTERFACE_NAME, mapMap);
        log.info("\u7f13\u5b58\u63a5\u53e3\u4fe1\u606f\u5b8c\u6bd5");
    }

    private void cacheCoverage() {
        List coverageList = this.atinCoverageMapper.getAll();
        HashMap<String, AtinCoverage> coverageMap = new HashMap<String, AtinCoverage>();
        for (AtinCoverage coverage : coverageList) {
            coverageMap.put(coverage.getCoverageCode(), coverage);
        }
        SERVICE_CACHE.put(CACHE_COVERAGE_NAME, coverageMap);
        log.info("\u7f13\u5b58\u9669\u79cd\u5b8c\u6bd5");
    }

    private void cacheInsurer() {
        List insurerList = this.atinInsurerMapper.getAll();
        HashMap<String, AtinInsurer> insurerMap = new HashMap<String, AtinInsurer>();
        for (AtinInsurer insurer : insurerList) {
            insurerMap.put(insurer.getCode(), insurer);
        }
        SERVICE_CACHE.put(CACHE_INSURER_NAME, insurerMap);
        log.info("\u7f13\u5b58\u4fdd\u9669\u516c\u53f8\u4fe1\u606f\u5b8c\u6bd5");
    }

    private void cacheInsurerCity() {
        List atinInsurerCityList = this.atinInsurerCityMapper.getAll(Integer.valueOf(1));
        HashMap<String, List> atinInsurerCityCity = new HashMap<String, List>();
        for (AtinInsurerCity atinInsurerCity : atinInsurerCityList) {
            List insuComCityList = (List)atinInsurerCityCity.get(atinInsurerCity.getShortLicenseNo());
            insuComCityList = CommonUtil.isNotEmpty((Collection)insuComCityList) ? insuComCityList : new ArrayList();
            insuComCityList.add(atinInsurerCity);
            atinInsurerCityCity.put(atinInsurerCity.getShortLicenseNo(), insuComCityList);
        }
        SERVICE_CACHE.put(CACHE_INSURER_CITY_NAME, atinInsurerCityCity);
        log.info("\u7f13\u5b58\u5f00\u901a\u57ce\u5e02\u5b8c\u6bd5");
    }
}

