/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.arthas.service.common;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.HttpUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.arthas.domain.dto.atin.CbsOutNotifyDto;
import com.zhlh.arthas.domain.dto.atin.RmOutNotifyDto;
import com.zhlh.arthas.domain.model.AtinOrder;
import com.zhlh.arthas.domain.model.Origin;
import com.zhlh.arthas.service.OrderService;
import com.zhlh.arthas.service.OriginNotifyUrlService;
import com.zhlh.arthas.service.OriginService;
import com.zhlh.arthas.service.common.AuthHelper;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyUtil {
    private static final Logger log = LoggerFactory.getLogger(NotifyUtil.class);
    @Autowired
    private OriginService originService;
    @Autowired
    private OriginNotifyUrlService originNotifyUrlService;
    @Autowired
    private OrderService orderService;
    private final String SUCCESS = "success";

    public String notifyOrigin(AtinOrder order, String notifyType) {
        log.info("\u8fdb\u5165\u901a\u77e5\u7b2c\u4e09\u65b9\u6e20\u9053\u5546\u6d41\u7a0b");
        String originCode = order.getOriginCode();
        Origin origin = this.originService.getOriginByCode(order.getOriginCode());
        String url = this.originNotifyUrlService.getByCodeAndType(originCode, notifyType);
        if (CommonUtil.isEmpty((String)url)) {
            return "success";
        }
        if ("rm_notify".equals(notifyType)) {
            log.info("\u901a\u77e5\u7b2c\u4e09\u65b9\u6e20\u9053\u5546\u5f00\u59cb,type:" + notifyType);
            RmOutNotifyDto rmOutNotifyDto = this.orderService.getRmOutNotify(order);
            return this.sendNotity(originCode, origin.getToken(), rmOutNotifyDto, url);
        }
        if ("cbs_notify".equals(notifyType)) {
            log.info("\u901a\u77e5\u7b2c\u4e09\u65b9\u6e20\u9053\u5546\u5f00\u59cb,type:" + notifyType);
            CbsOutNotifyDto cbsOutNotifyDto = this.orderService.getCbsNotifyDto(order);
            return this.sendNotity(originCode, origin.getToken(), cbsOutNotifyDto, url);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendNotity(String originCode, String token, Object object, String url) {
        String timeStr = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String sign = AuthHelper.buildSign(originCode, token, timeStr);
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        headerList.add(new BasicHeader("sign", sign));
        headerList.add(new BasicHeader("origin", originCode));
        headerList.add(new BasicHeader("timeStr", timeStr));
        try {
            log.info("json:" + JsonUtil.beanToJSONWithNull((Object)object));
            String result = HttpUtil.doPost((String)url, (String)JsonUtil.beanToJSONWithNull((Object)object), headerList);
            log.info("\u901a\u77e5\u6e20\u9053\u5546\u7ed3\u679c\u8fd4\u56de" + result);
            String string = result;
            return string;
        }
        finally {
            log.info("\u901a\u77e5\u7ed3\u675f");
        }
    }
}

