/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpsUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(65000).setConnectTimeout(65000).setConnectionRequestTimeout(65000).build();

    public static String doPost(String url, String content, List<Header> headers) {
        return HttpsUtil.doPost(url, content, headers, DEFAULT_CHARSET);
    }

    public static String doPost(String url, String content) {
        return HttpsUtil.doPost(url, content, (List<Header>)null, DEFAULT_CHARSET);
    }

    public static String doPost(String url, Map<String, String> params, List<Header> headers) {
        return HttpsUtil.doPost(url, params, headers, DEFAULT_CHARSET);
    }

    public static String doPostJson(String url, String json, List<Header> headers, String charset) throws Exception {
        Map params = (Map)JSONObject.parseObject((String)json, Map.class);
        return HttpsUtil.doPost(url, params, headers, charset);
    }

    public static String doPost(String url, String content, List<Header> headers, String charset) {
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        try {
            return HttpsUtil.doPost(url, (HttpEntity)entity, headers, charset, null);
        }
        catch (IOException var6) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var6.getMessage());
        }
    }

    public static String doPost(String url, Map<String, String> params, List<Header> headers, String charset) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            nameValuePairs.add(new BasicNameValuePair(key, val));
        }
        try {
            UrlEncodedFormEntity e1 = new UrlEncodedFormEntity(nameValuePairs, charset);
            return HttpsUtil.doPost(url, (HttpEntity)e1, headers, charset, null);
        }
        catch (Exception var9) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var9.getMessage());
        }
    }

    public static String doGet(String url, final String charset) {
        String responseBody = null;
        CloseableHttpClient httpClient = HttpsUtil.createSSLInsecureClient();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        try {
            ResponseHandler e = new ResponseHandler(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)charset) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            responseBody = (String)httpClient.execute((HttpUriRequest)httpGet, e);
        }
        catch (IOException var13) {
            throw new RuntimeException("doGet\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var13.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
        }
        return responseBody;
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        if (params != null && params.size() != 0) {
            url = url + "?";
            Set<String> keys = params.keySet();
            for (String key : keys) {
                url = url + key + "=" + params.get(key) + "&";
            }
            url = url.substring(0, url.length() - 1);
        }
        return HttpsUtil.doGet(url, charset);
    }

    public static String doGet(String url) {
        return HttpsUtil.doGet(url, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, HttpEntity httpEntity, List<Header> headers, final String charset, BasicCookieStore basicCookieStore) throws IOException {
        CloseableHttpClient httpClient = HttpsUtil.createSSLInsecureClient(basicCookieStore);
        String responseBody = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(httpEntity);
        if (headers != null && headers.size() > 0) {
            Header[] e = new Header[headers.size()];
            httpPost.setHeaders(headers.toArray(e));
        }
        try {
            ResponseHandler e1 = new ResponseHandler(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 400) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            return EntityUtils.toString((HttpEntity)entity, (String)charset);
                        }
                        throw new ClientProtocolException("Response entity is null");
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            responseBody = (String)httpClient.execute((HttpUriRequest)httpPost, e1);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var14) {
                var14.printStackTrace();
            }
        }
        return responseBody;
    }

    public static List<Cookie> getCookie(String url, String content, String charset) {
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        try {
            HttpsUtil.doPost(url, (HttpEntity)entity, null, charset, basicCookieStore);
        }
        catch (IOException var6) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var6.getMessage());
        }
        List cookies = basicCookieStore.getCookies();
        return cookies;
    }

    public static List<Cookie> getCookie(String url, String content, List<Header> headers, String charset) {
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        try {
            HttpsUtil.doPost(url, (HttpEntity)entity, headers, charset, basicCookieStore);
        }
        catch (IOException var7) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var7.getMessage());
        }
        return basicCookieStore.getCookies();
    }

    public static List<Cookie> getCookie(String url, String content, List<Header> headers, String charset, StringBuffer result) {
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        try {
            String e = HttpsUtil.doPost(url, (HttpEntity)entity, headers, charset, basicCookieStore);
            result.append(e);
        }
        catch (IOException var8) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + var8.getMessage());
        }
        return basicCookieStore.getCookies();
    }

    public static CloseableHttpClient createSSLInsecureClient(BasicCookieStore basicCookieStore) {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslcsf).setDefaultCookieStore((CookieStore)basicCookieStore).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }

    public static CloseableHttpClient createSSLInsecureClient() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslcsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }
}

