/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;

public class DownloadUtil {
    public static void localFileDownLoad(String filePath, HttpServletResponse response) {
        try {
            String fileName = filePath.substring(filePath.lastIndexOf(System.getProperty("file.separator")) + 1);
            File file = new File(filePath);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(filePath));
            DownloadUtil.confRespons(fileName, file.length(), response);
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[10240];
            int ch = 0;
            while ((ch = ((InputStream)fis).read(buffer)) != -1) {
                ((OutputStream)toClient).write(buffer, 0, ch);
            }
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
            ((InputStream)fis).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void remotFileDownLoad(String filePath, HttpServletResponse response) {
        try {
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            URL url = new URL(filePath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream inStream = conn.getInputStream();
            DownloadUtil.confRespons(fileName, Long.parseLong(conn.getHeaderField("Content-Length")), response);
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[10240];
            int byteread = 0;
            while ((byteread = inStream.read(buffer)) != -1) {
                ((OutputStream)toClient).write(buffer, 0, byteread);
            }
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
            inStream.close();
            conn.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void confRespons(String fileName, Long fileLen, HttpServletResponse response) throws UnsupportedEncodingException {
        response.reset();
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        response.addHeader("Content-Length", "" + fileLen);
        response.setContentType("application/octet-stream");
    }

    public static void delFile(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }
}

