/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class StreamUtil {
    private static final int bufferSize = 512;

    public static byte[] consume(InputStream in) throws IOException {
        int size;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        byte[] buffer = new byte[512];
        while ((size = in.read(buffer)) > 0) {
            out.write(buffer, 0, size);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    public static String consume(Reader in) throws IOException {
        int read;
        if (in == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(512);
        char[] buffer = new char[512];
        while ((read = in.read(buffer)) > 0) {
            out.append(buffer, 0, read);
        }
        in.close();
        return out.toString();
    }

    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

