/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.zhlh.Tiny.util.EscapeUtil;
import java.security.MessageDigest;

public class Md5Util {
    private static final char[] HEX_CHARS_LOWER = "0123456789abcdef".toCharArray();
    private static final char[] HEX_CHARS_UPPER = "0123456789ABCDEF".toCharArray();

    public static byte[] md5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest.digest(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] md5(String s) {
        return Md5Util.md5(Md5Util.toBytes(s));
    }

    public static String md5AsUpperHex(String s) {
        return Md5Util.md5AsUpperHex(Md5Util.toBytes(s));
    }

    public static String md5AsLowerHex(String s) {
        return Md5Util.md5AsLowerHex(Md5Util.toBytes(s));
    }

    public static String md5AsUpperHex(byte[] bytes) {
        return Md5Util.asHex(Md5Util.md5(bytes), false);
    }

    public static String md5AsLowerHex(byte[] bytes) {
        return Md5Util.asHex(Md5Util.md5(bytes), true);
    }

    private static byte[] toBytes(String s) {
        if (s == null) {
            s = "";
        }
        return s.getBytes(EscapeUtil.CHARSET_UTF8);
    }

    private static String asHex(byte[] bytes, boolean lowerCase) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException();
        }
        char[] template = lowerCase ? HEX_CHARS_LOWER : HEX_CHARS_UPPER;
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = template[b >>> 4 & 0xF];
            chars[i + 1] = template[b & 0xF];
        }
        return new String(chars);
    }
}

