/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.util.RegexUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpUtil {
    private static Logger LOG = LoggerFactory.getLogger(HttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        LOG.info(String.format("Http Get start, URL[%s].", url));
        if (!RegexUtil.isValidURL(url)) {
            return null;
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            String entity1;
            CloseableHttpResponse e = httpClient.execute((HttpUriRequest)new HttpGet(url));
            int status = e.getStatusLine().getStatusCode();
            String content = "";
            if (status == 200) {
                String tmp;
                HttpEntity entity = e.getEntity();
                BufferedReader e1 = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                while ((tmp = e1.readLine()) != null) {
                    content = content + tmp + "\r\n";
                }
            }
            LOG.info(String.format("Http Get finish, URL[%s], Response[status: %s, content: %s].", url, status, content));
            String string = entity1 = content;
            return string;
        }
        catch (ClientProtocolException var18) {
            var18.printStackTrace();
        }
        catch (IOException var19) {
            var19.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var17) {
                var17.printStackTrace();
            }
        }
        return null;
    }

    public static String get(String url, Map<String, String> params) {
        if (RegexUtil.isValidURL(url) && params != null && params.size() != 0) {
            url = url + "?";
            Set<String> keys = params.keySet();
            for (String key : keys) {
                url = url + key + "=" + params.get(key) + "&";
            }
            url = url.substring(0, url.length() - 1);
            return HttpUtil.get(url);
        }
        return null;
    }

    public static String post(String url, Map<String, String> params) {
        LOG.info(String.format("Http Post start, URL[%s], Params[%s].", url, params));
        try {
            if (RegexUtil.isValidURL(url) && params != null && params.size() != 0) {
                String response2;
                Set<String> ex = params.keySet();
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String response2 : ex) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(response2, params.get(response2));
                    paramList.add(nameValuePair);
                }
                UrlEncodedFormEntity formEntity1 = new UrlEncodedFormEntity(paramList, Consts.UTF_8);
                response2 = HttpUtil.doPost(url, (HttpEntity)formEntity1);
                LOG.info(String.format("Http Post finish, URL[%s], Params[%s], Response[%s].", url, params, response2));
                return response2;
            }
            return null;
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return "";
        }
    }

    public static String post(String urlStr, String info) {
        LOG.info(String.format("Http Post start, URL[%s], ParamContent[%s].", urlStr, info));
        StringBuffer result = new StringBuffer();
        try {
            URL e = new URL(urlStr);
            URLConnection con = e.openConnection();
            con.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
            out.write(info);
            out.flush();
            out.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = "";
            line = br.readLine();
            while (line != null) {
                result.append(line);
                line = br.readLine();
            }
        }
        catch (MalformedURLException var8) {
            LOG.error("\u6267\u884cPost\u8bf7\u6c42\u65f6\u53d1\u751fMalformedURLException\u9519\u8bef," + var8.getMessage());
            var8.printStackTrace();
        }
        catch (IOException var9) {
            LOG.error("\u6267\u884cPost\u8bf7\u6c42\u65f6\u53d1\u751fIOException\u9519\u8bef," + var9.getMessage());
            var9.printStackTrace();
        }
        LOG.info("result:" + result.toString());
        return result.toString();
    }

    public static String postJSON(String url, String json) throws Exception {
        if (RegexUtil.isValidURL(url) && StringUtils.hasText((String)json)) {
            Map params = (Map)JSONObject.parseObject((String)json, Map.class);
            return HttpUtil.post(url, params);
        }
        return null;
    }

    public static String doPost(String url, String jsonContent, List<Header> headers) throws UnsupportedEncodingException {
        StringEntity s = new StringEntity(jsonContent, Consts.UTF_8);
        try {
            return HttpUtil.doPost(url, (HttpEntity)s, headers);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String postWithHead(String url, Map<String, String> params, List<Header> header) {
        LOG.info(String.format("Http Post start, URL[%s], Params[%s].", url, params));
        try {
            if (RegexUtil.isValidURL(url) && params != null && params.size() != 0) {
                String response2;
                Set<String> ex = params.keySet();
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String response2 : ex) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(response2, params.get(response2));
                    paramList.add(nameValuePair);
                }
                UrlEncodedFormEntity formEntity1 = new UrlEncodedFormEntity(paramList, Consts.UTF_8);
                response2 = HttpUtil.doPost(url, (HttpEntity)formEntity1, header);
                LOG.info(String.format("Http Post finish, URL[%s], Params[%s], Response[%s].", url, params, response2));
                return response2;
            }
            return "";
        }
        catch (Exception var7) {
            LOG.info(String.format("Http Post end with exception, URL[%s], Params[%s], Exception[%s].", url, params, var7));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, HttpEntity httpEntity, List<Header> headers) throws IOException {
        String var5;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(httpEntity);
        for (Header header : headers) {
            httpPost.setHeader(header);
        }
        ResponseHandler responseHandler = new ResponseHandler(){

            public String handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                String content = "";
                if (status >= 200 && status < 300) {
                    String tmp;
                    HttpEntity entity = response.getEntity();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                    while ((tmp = reader.readLine()) != null) {
                        content = content + tmp + "\r\n";
                    }
                }
                return content;
            }
        };
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            var5 = (String)httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
        }
        return var5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, HttpEntity httpEntity) throws IOException {
        String var5;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(httpEntity);
        ResponseHandler responseHandler = new ResponseHandler(){

            public String handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                String content = "";
                if (status >= 200 && status < 300) {
                    String tmp;
                    HttpEntity entity = response.getEntity();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                    while ((tmp = reader.readLine()) != null) {
                        content = content + tmp + "\r\n";
                    }
                }
                return content;
            }
        };
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            var5 = (String)httpClient.execute((HttpUriRequest)httpPost, responseHandler);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
        }
        return var5;
    }
}

