/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.dozer.DozerBeanMapper;

public class BeanUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static DozerBeanMapper dozer = new DozerBeanMapper();
    private static final Map<Class<?>, Map<Class<?>, BeanCopier>> beanCopiers = new ConcurrentHashMap(128);

    public static void eachProperties(Object bean, EachPropertiesHandler eachPropertiesHandler) {
        BeanUtil.eachPropertiesInner(bean.getClass(), bean, eachPropertiesHandler);
    }

    public static Map<String, Object> beanToMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanUtil.beanToMapInner(bean.getClass(), bean, map);
        return map;
    }

    public static String beanToQueryString(Object bean, String dateFormat, String charset) {
        StringBuffer string = new StringBuffer();
        BeanUtil.beanToQueryStringInner(bean.getClass(), string, bean, dateFormat, charset);
        if (string.length() > 0) {
            string.delete(0, 1);
        }
        return string.toString();
    }

    public static String beanToQueryString(Object bean, String dateFormat) {
        return BeanUtil.beanToQueryString(bean, dateFormat, DEFAULT_CHARSET);
    }

    public static String beanToQueryString(Object bean) {
        return BeanUtil.beanToQueryString(bean, "yyyy-MM-dd", DEFAULT_CHARSET);
    }

    public static <T> T quickMap(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        BeanCopier beanCopier = BeanUtil.getBeanCopier(source.getClass(), targetClass);
        T to = null;
        try {
            to = targetClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Class " + targetClass + "not hava constructor is no params", e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Class " + targetClass + "not hava constructor is no params", e);
        }
        beanCopier.copy(source, to, null);
        return to;
    }

    public static <T> List<T> quickMapList(Collection<?> sourceList, Class<T> targetClass) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (sourceList.isEmpty()) {
            return targetList;
        }
        Iterator<?> it = sourceList.iterator();
        BeanCopier beanCopier = BeanUtil.getBeanCopier(it.next().getClass(), targetClass);
        try {
            for (Object source : sourceList) {
                T target = targetClass.newInstance();
                beanCopier.copy(source, target, null);
                targetList.add(target);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Class " + targetClass + "not hava constructor is no params", e);
        }
        return targetList;
    }

    public static void quickCopy(Object source, Object target) {
        BeanUtil.notNull(source);
        BeanUtil.notNull(target);
        BeanCopier beanCopier = BeanUtil.getBeanCopier(source.getClass(), target.getClass());
        beanCopier.copy(source, target, null);
    }

    public static <T> T adviceMap(Object source, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        return (T)dozer.map(source, destinationClass);
    }

    public static <T> List<T> adviceMapList(Collection<?> sourceList, Class<T> destinationClass) {
        ArrayList<Object> destinationList = new ArrayList<Object>();
        for (Object sourceObject : sourceList) {
            Object destinationObject = dozer.map(sourceObject, destinationClass);
            destinationList.add(destinationObject);
        }
        return destinationList;
    }

    public static void adviceCopy(Object source, Object destinationObject) {
        BeanUtil.notNull(source);
        BeanUtil.notNull(destinationObject);
        dozer.map(source, destinationObject);
    }

    public static String getClassName(Object po) {
        String returnString = StringUtils.capitalize((String)po.getClass().getSimpleName());
        return returnString;
    }

    public static String getObjectName(Class<?> c) {
        String returnString = StringUtils.uncapitalize((String)c.getSimpleName());
        return returnString;
    }

    private static void beanToMapInner(Class<?> thisClass, Object bean, Map<String, Object> map) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToMap(bean, map, method, 3);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToMap(bean, map, method, 2);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.beanToMapInner(superClass, bean, map);
        }
    }

    private static void pubValueToMap(Object bean, Map<String, Object> map, Method method, int methedNamePrefixLength) {
        Object value = BeanUtil.invoke(bean, method);
        if (value != null) {
            String methodName = method.getName();
            String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
            map.put(fieldName, value);
        }
    }

    private static void pubValueToString(Object bean, StringBuffer string, Method method, int methedNamePrefixLength, String dateFormat, String charset) {
        Object value = BeanUtil.invoke(bean, method);
        if (value != null) {
            boolean tag = true;
            if (Boolean.class.isInstance(value)) {
                tag = Boolean.TRUE.equals(value);
            }
            if (tag) {
                String methodName = method.getName();
                String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
                if (Date.class.isInstance(value)) {
                    value = DateFormatUtils.format((Date)((Date)value), (String)dateFormat);
                }
                try {
                    value = URLEncoder.encode(value + "", charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("unsupported encoding exception", e);
                }
                string.append("&" + fieldName + "=" + value);
            }
        }
    }

    private static void beanToQueryStringInner(Class<?> thisClass, StringBuffer string, Object bean, String dateFormat, String charset) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToString(bean, string, method, 3, dateFormat, charset);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToString(bean, string, method, 2, dateFormat, charset);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.beanToQueryStringInner(superClass, string, bean, dateFormat, charset);
        }
    }

    private static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass) {
        Map<Class<?>, BeanCopier> mapInner = beanCopiers.get(sourceClass);
        BeanCopier beanCopier = null;
        if (mapInner == null) {
            mapInner = new ConcurrentHashMap(128);
            beanCopier = BeanCopier.create(sourceClass, targetClass, (boolean)false);
            mapInner.put(targetClass, beanCopier);
            beanCopiers.put(sourceClass, mapInner);
        } else {
            beanCopier = mapInner.get(targetClass);
            if (beanCopier == null) {
                beanCopier = BeanCopier.create(sourceClass, targetClass, (boolean)false);
                mapInner.put(targetClass, beanCopier);
            }
        }
        return beanCopier;
    }

    private static void eachPropertiesInner(Class<?> thisClass, Object bean, EachPropertiesHandler eachPropertiesHandler) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToHandler(bean, method, 3, eachPropertiesHandler);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToHandler(bean, method, 2, eachPropertiesHandler);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.eachPropertiesInner(superClass, bean, eachPropertiesHandler);
        }
    }

    private static void pubValueToHandler(Object bean, Method method, int methedNamePrefixLength, EachPropertiesHandler eachPropertiesHandler) {
        Object value = BeanUtil.invoke(bean, method);
        if (value != null) {
            String methodName = method.getName();
            String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
            eachPropertiesHandler.handler(fieldName, value);
        }
    }

    private static Object invoke(Object bean, Method method) {
        Object value = null;
        try {
            value = method.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e.getTargetException().getMessage(), e);
        }
        return value;
    }

    private static void notNull(Object object) {
        BeanUtil.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static interface EachPropertiesHandler {
        public void handler(String var1, Object var2);
    }
}

