/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.install.internal;

import java.io.File;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.transfer.artifact.install.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.install.internal.Maven30ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.install.internal.Maven31ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.install.internal.MavenArtifactInstaller;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=ArtifactInstaller.class)
class DefaultArtifactInstaller
implements ArtifactInstaller,
Contextualizable {
    private PlexusContainer container;
    @Requirement
    private RepositoryManager repositoryManager;

    DefaultArtifactInstaller() {
    }

    @Override
    public void install(ProjectBuildingRequest request, Collection<Artifact> mavenArtifacts) throws ArtifactInstallerException, IllegalArgumentException {
        this.validateParameters(request, mavenArtifacts);
        try {
            this.getMavenArtifactInstaller(request).install(mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactInstallerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void install(ProjectBuildingRequest request, File localRepositry, Collection<Artifact> mavenArtifacts) throws ArtifactInstallerException {
        this.validateParameters(request, mavenArtifacts);
        if (localRepositry == null) {
            throw new IllegalArgumentException("The parameter localRepository is not allowed to be null.");
        }
        if (!localRepositry.isDirectory()) {
            throw new IllegalArgumentException("The parameter localRepository must be a directory.");
        }
        ProjectBuildingRequest newRequest = this.repositoryManager.setLocalRepositoryBasedir(request, localRepositry);
        try {
            this.getMavenArtifactInstaller(newRequest).install(mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactInstallerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void validateParameters(ProjectBuildingRequest request, Collection<Artifact> mavenArtifacts) {
        if (request == null) {
            throw new IllegalArgumentException("The parameter request is not allowed to be null.");
        }
        if (mavenArtifacts == null) {
            throw new IllegalArgumentException("The parameter mavenArtifacts is not allowed to be null.");
        }
        if (mavenArtifacts.isEmpty()) {
            throw new IllegalArgumentException("The collection mavenArtifacts is not allowed to be empty.");
        }
    }

    private boolean isMaven31() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.aether.artifact.Artifact");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private MavenArtifactInstaller getMavenArtifactInstaller(ProjectBuildingRequest buildingRequest) throws ComponentLookupException, ArtifactInstallerException {
        if (this.isMaven31()) {
            org.eclipse.aether.RepositorySystem repositorySystem = (org.eclipse.aether.RepositorySystem)this.container.lookup(org.eclipse.aether.RepositorySystem.class);
            org.eclipse.aether.RepositorySystemSession session = (org.eclipse.aether.RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            return new Maven31ArtifactInstaller(repositorySystem, session);
        }
        RepositorySystem repositorySystem = (RepositorySystem)this.container.lookup(RepositorySystem.class);
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        return new Maven30ArtifactInstaller(repositorySystem, session);
    }
}

