/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Slice;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;

public class ResultProcessor {
    private final QueryMethod method;
    private final ProjectingConverter converter;
    private final ProjectionFactory factory;
    private ReturnedType type;

    ResultProcessor(QueryMethod method, ProjectionFactory factory) {
        this(method, factory, method.getReturnedObjectType());
    }

    private ResultProcessor(QueryMethod method, ProjectionFactory factory, Class<?> type) {
        Assert.notNull((Object)method, (String)"QueryMethod must not be null!");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        this.method = method;
        this.type = ReturnedType.of(type, method.getDomainClass(), factory);
        this.converter = new ProjectingConverter(this.type, factory);
        this.factory = factory;
    }

    public ResultProcessor withDynamicProjection(ParameterAccessor accessor) {
        if (accessor == null) {
            return this;
        }
        Class<?> projectionType = accessor.getDynamicProjection();
        return projectionType == null ? this : new ResultProcessor(this.method, this.factory, projectionType);
    }

    public ReturnedType getReturnedType() {
        return this.type;
    }

    public <T> T processResult(Object source) {
        return this.processResult(source, NoOpConverter.INSTANCE);
    }

    public <T> T processResult(Object source, Converter<Object, Object> preparingConverter) {
        if (source == null || this.type.isInstance(source) || !this.type.isProjecting()) {
            return (T)source;
        }
        Assert.notNull(preparingConverter, (String)"Preparing converter must not be null!");
        ChainingConverter converter = ChainingConverter.of(this.type.getReturnedType(), preparingConverter).and(this.converter);
        if (source instanceof Slice && this.method.isPageQuery() || this.method.isSliceQuery()) {
            return (T)((Slice)source).map(converter);
        }
        if (source instanceof Collection && this.method.isCollectionQuery()) {
            Collection collection = (Collection)source;
            Collection<Object> target = ResultProcessor.createCollectionFor(collection);
            for (Object columns : collection) {
                target.add(this.type.isInstance(columns) ? columns : converter.convert(columns));
            }
            return (T)target;
        }
        if (ReflectionUtils.isJava8StreamType(source.getClass()) && this.method.isStreamQuery()) {
            return (T)new StreamQueryResultHandler(this.type, converter).handle(source);
        }
        return (T)converter.convert(source);
    }

    private static Collection<Object> createCollectionFor(Collection<?> source) {
        try {
            return CollectionFactory.createCollection(source.getClass(), (int)source.size());
        }
        catch (RuntimeException o_O) {
            return CollectionFactory.createApproximateCollection(source, (int)source.size());
        }
    }

    static class StreamQueryResultHandler {
        @NonNull
        private final ReturnedType returnType;
        @NonNull
        private final Converter<Object, Object> converter;

        public Object handle(Object source) {
            Assert.isInstanceOf(Stream.class, (Object)source, (String)"Source must not be null and an instance of Stream!");
            return ((Stream)source).map(new Function<Object, Object>(){

                @Override
                public Object apply(Object element) {
                    return StreamQueryResultHandler.this.returnType.isInstance(element) ? element : StreamQueryResultHandler.this.converter.convert(element);
                }
            });
        }

        @ConstructorProperties(value={"returnType", "converter"})
        public StreamQueryResultHandler(@NonNull ReturnedType returnType, @NonNull Converter<Object, Object> converter) {
            if (returnType == null) {
                throw new IllegalArgumentException("returnType is null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("converter is null");
            }
            this.returnType = returnType;
            this.converter = converter;
        }
    }

    private static class ProjectingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ReturnedType type;
        @NonNull
        private final ProjectionFactory factory;
        private final ConversionService conversionService = new DefaultConversionService();

        public Object convert(Object source) {
            Class<?> targetType = this.type.getReturnedType();
            if (targetType.isInterface()) {
                return this.factory.createProjection(targetType, this.getProjectionTarget(source));
            }
            return this.conversionService.convert(source, targetType);
        }

        private Object getProjectionTarget(Object source) {
            if (source != null && source.getClass().isArray()) {
                source = Arrays.asList((Object[])source);
            }
            if (source instanceof Collection) {
                return ProjectingConverter.toMap((Collection)source, this.type.getInputProperties());
            }
            return source;
        }

        private static Map<String, Object> toMap(Collection<?> values, List<String> names) {
            int i = 0;
            HashMap<String, Object> result = new HashMap<String, Object>(values.size());
            for (Object element : values) {
                result.put(names.get(i++), element);
            }
            return result;
        }

        @ConstructorProperties(value={"type", "factory"})
        public ProjectingConverter(@NonNull ReturnedType type, @NonNull ProjectionFactory factory) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("factory is null");
            }
            this.type = type;
            this.factory = factory;
        }
    }

    private static enum NoOpConverter implements Converter<Object, Object>
    {
        INSTANCE;


        public Object convert(Object source) {
            return source;
        }
    }

    private static class ChainingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Converter<Object, Object> delegate;

        public ChainingConverter and(final Converter<Object, Object> converter) {
            Assert.notNull(converter, (String)"Converter must not be null!");
            return new ChainingConverter(this.targetType, new Converter<Object, Object>(){

                public Object convert(Object source) {
                    Object intermediate = ChainingConverter.this.convert(source);
                    return ChainingConverter.this.targetType.isInstance(intermediate) ? intermediate : converter.convert(intermediate);
                }
            });
        }

        public Object convert(Object source) {
            return this.delegate.convert(source);
        }

        private ChainingConverter(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is null");
            }
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is null");
            }
            this.targetType = targetType;
            this.delegate = delegate;
        }

        public static ChainingConverter of(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            return new ChainingConverter(targetType, delegate);
        }
    }
}

