/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.resources.LoopResources;
import reactor.util.Logger;
import reactor.util.Loggers;

public class UdpResources
implements LoopResources {
    final LoopResources defaultLoops;
    static final Logger log = Loggers.getLogger(UdpResources.class);
    static final AtomicReference<UdpResources> udpResources;
    static final Function<LoopResources, UdpResources> ON_UDP_NEW;
    static final int DEFAULT_UDP_THREAD_COUNT;

    public static UdpResources get() {
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static UdpResources set(LoopResources loops) {
        return UdpResources.getOrCreate(loops, ON_UDP_NEW, "udp");
    }

    public static UdpResources reset() {
        UdpResources.shutdown();
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static void shutdown() {
        UdpResources resources = udpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> shutdownLater() {
        return Mono.defer(() -> {
            UdpResources resources = udpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater();
            }
            return Mono.empty();
        });
    }

    protected UdpResources(LoopResources defaultLoops) {
        this.defaultLoops = defaultLoops;
    }

    protected void _dispose() {
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater() {
        return this.defaultLoops.disposeLater();
    }

    public boolean isDisposed() {
        return this.defaultLoops.isDisposed();
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.defaultLoops.onChannel(group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.defaultLoops.onDatagramChannel(group);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.defaultLoops.onServerChannel(group);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    @Override
    public boolean preferNative() {
        return this.defaultLoops.preferNative();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    protected static UdpResources getOrCreate(@Nullable LoopResources loops, Function<LoopResources, UdpResources> onNew, String name) {
        UdpResources resources;
        while ((resources = udpResources.get()) == null || loops != null) {
            UdpResources update = UdpResources.create(resources, loops, name, onNew);
            if (udpResources.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (log.isWarnEnabled()) {
                        log.warn("[{}] resources will use a new LoopResources: {},the previous LoopResources will be disposed", new Object[]{name, loops});
                    }
                    resources.defaultLoops.dispose();
                } else {
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", new Object[]{name, loopType, update.defaultLoops});
                    }
                }
                return update;
            }
            update._dispose();
        }
        return resources;
    }

    static <T extends UdpResources> T create(@Nullable T previous, @Nullable LoopResources loops, String name, Function<LoopResources, T> onNew) {
        loops = previous == null ? (loops == null ? LoopResources.create(name, DEFAULT_UDP_THREAD_COUNT, true) : loops) : (loops == null ? previous.defaultLoops : loops);
        return (T)((UdpResources)onNew.apply(loops));
    }

    static {
        DEFAULT_UDP_THREAD_COUNT = Integer.parseInt(System.getProperty("reactor.netty.udp.ioThreadCount", "" + Schedulers.DEFAULT_POOL_SIZE));
        ON_UDP_NEW = UdpResources::new;
        udpResources = new AtomicReference();
    }
}

