/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.uri.AeronUri;

class PublicationParams {
    int mtuLength = 0;
    int termLength = 0;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    boolean isReplay = false;

    PublicationParams() {
    }

    static int getTermBufferLength(AeronUri aeronUri, int defaultTermLength) {
        String termLengthParam = aeronUri.get("term-length");
        int termLength = defaultTermLength;
        if (null != termLengthParam) {
            termLength = Integer.parseInt(termLengthParam);
            Configuration.validateTermBufferLength(termLength);
        }
        return termLength;
    }

    static int getMtuLength(AeronUri aeronUri, int defaultMtuLength) {
        int mtuLength = defaultMtuLength;
        String mtu = aeronUri.get("mtu");
        if (null != mtu) {
            mtuLength = Integer.parseInt(mtu);
            Configuration.validateMtuLength(mtuLength);
        }
        return mtuLength;
    }

    static PublicationParams getPublicationParams(MediaDriver.Context context, AeronUri aeronUri, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams();
        params.mtuLength = PublicationParams.getMtuLength(aeronUri, context.mtuLength());
        params.termLength = PublicationParams.getTermBufferLength(aeronUri, isIpc ? context.ipcTermBufferLength() : context.publicationTermBufferLength());
        if (isExclusive) {
            int count = 0;
            String initTermIdStr = aeronUri.get("init-term-id");
            count = initTermIdStr != null ? count + 1 : count;
            String termIdStr = aeronUri.get("term-id");
            count = termIdStr != null ? count + 1 : count;
            String termOffsetStr = aeronUri.get("term-offset");
            int n = count = termOffsetStr != null ? count + 1 : count;
            if (count > 0) {
                if (count < 3) {
                    throw new IllegalArgumentException("Params must be used as a complete set: init-term-id term-id term-offset");
                }
                params.initialTermId = Integer.parseInt(initTermIdStr);
                params.termId = Integer.parseInt(termIdStr);
                params.termOffset = Integer.parseInt(termOffsetStr);
                if (params.termOffset > params.termLength) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
                }
                params.isReplay = true;
            }
        }
        return params;
    }
}

