/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.collections.ArrayListUtil;

public class MinMulticastFlowControl
implements FlowControl {
    private static final String RECEIVER_TIMEOUT_PROP_NAME = "aeron.MinMulticastFlowControl.receiverTimeout";
    private static final long RECEIVER_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toNanos(2L);
    private static final long RECEIVER_TIMEOUT = Long.getLong("aeron.MinMulticastFlowControl.receiverTimeout", RECEIVER_TIMEOUT_DEFAULT);
    private final ArrayList<Receiver> receiverList = new ArrayList();

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long nowNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        int size = receiverList.size();
        for (int i = 0; i < size; ++i) {
            Receiver receiver = receiverList.get(i);
            if (receiverId == receiver.receiverId) {
                receiver.lastPositionPlusWindow = position + windowLength;
                receiver.timeOfLastStatusMessage = nowNs;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (!isExisting) {
            receiverList.add(new Receiver(position + windowLength, nowNs, receiverId, receiverAddress));
            minPosition = Math.min(minPosition, position + windowLength);
        }
        return Math.max(senderLimit, minPosition);
    }

    @Override
    public void initialize(int initialTermId, int termBufferCapacity) {
    }

    @Override
    public long onIdle(long nowNs, long senderLimit) {
        int lastIndex;
        long minPosition = Long.MAX_VALUE;
        ArrayList<Receiver> receiverList = this.receiverList;
        for (int i = lastIndex = receiverList.size() - 1; i >= 0; --i) {
            Receiver receiver = receiverList.get(i);
            if (nowNs > receiver.timeOfLastStatusMessage + RECEIVER_TIMEOUT) {
                ArrayListUtil.fastUnorderedRemove(receiverList, (int)i, (int)lastIndex);
                --lastIndex;
                continue;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        return receiverList.size() > 0 ? minPosition : senderLimit;
    }

    static class Receiver {
        long lastPositionPlusWindow;
        long timeOfLastStatusMessage;
        long receiverId;
        InetSocketAddress address;

        Receiver(long lastPositionPlusWindow, long now, long receiverId, InetSocketAddress receiverAddress) {
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessage = now;
            this.receiverId = receiverId;
            this.address = receiverAddress;
        }
    }
}

