/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.cmd.CreatePublicationImageCmd;
import io.aeron.driver.cmd.DriverConductorCmd;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.agrona.concurrent.status.AtomicCounter;

public class DriverConductorProxy {
    private final ThreadingMode threadingMode;
    private final Queue<DriverConductorCmd> commandQueue;
    private final AtomicCounter failCount;
    private DriverConductor driverConductor;

    public DriverConductorProxy(ThreadingMode threadingMode, Queue<DriverConductorCmd> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void driverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
    }

    public void createPublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int termOffset, int termLength, int mtuLength, InetSocketAddress controlAddress, InetSocketAddress srcAddress, ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.driverConductor.onCreatePublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, controlAddress, srcAddress, channelEndpoint);
        } else {
            this.offer(new CreatePublicationImageCmd(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, controlAddress, srcAddress, channelEndpoint));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(DriverConductorCmd cmd) {
        while (!this.commandQueue.offer(cmd)) {
            this.failCount.increment();
            Thread.yield();
        }
    }
}

