/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.zhlh.Tiny.page.bean.Page;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.karma.domain.model.AtinInsurer;
import com.zhlh.karma.domain.model.AtinOrder;
import com.zhlh.karma.domain.model.AtinPolicy;
import com.zhlh.karma.domain.model.AtinRakebackRecord;
import com.zhlh.karma.domain.model.AtinUser;
import com.zhlh.karma.domain.model.AtinUserInfo;
import com.zhlh.karma.dto.RakebackRecordDto;
import com.zhlh.karma.mapper.AtinOrderMapper;
import com.zhlh.karma.mapper.AtinPolicyMapper;
import com.zhlh.karma.mapper.AtinRakebackRecordMapper;
import com.zhlh.karma.mapper.AtinUserInfoMapper;
import com.zhlh.karma.mapper.AtinUserMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.service.RakeBackRecordService;
import com.zhlh.karma.service.common.ServiceUtil;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RakeBackRecordServiceImpl
extends BaseServiceImpl<AtinRakebackRecord>
implements RakeBackRecordService {
    @Autowired
    AtinRakebackRecordMapper rakebackRecordMapper;
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private AtinUserInfoMapper userInfoMapper;
    @Autowired
    private AtinOrderMapper orderMapper;
    @Autowired
    private AtinPolicyMapper policyMapper;

    @Override
    public BaseMapper<AtinRakebackRecord> getBaseMapper() {
        return this.rakebackRecordMapper;
    }

    @Override
    public Page<RakebackRecordDto> findUserPageByInViteUserId(Integer inviteUserId, Integer pageNo, Integer pageSize) {
        Integer id;
        Page result = new Page();
        ArrayList<RakebackRecordDto> dtos = new ArrayList<RakebackRecordDto>();
        Page page = new Page(pageNo.intValue(), pageSize.intValue());
        this.rakebackRecordMapper.findRecordPageById(inviteUserId, page);
        result.setPageNo(pageNo.intValue());
        result.setPageSize(pageSize.intValue());
        result.setTotalRecord(page.getTotalRecord());
        result.setTotalPage(page.getTotalPage());
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        for (AtinRakebackRecord rakebackRecord : page.getResults()) {
            RakebackRecordDto dto = new RakebackRecordDto();
            BeanUtils.copyProperties((Object)rakebackRecord, (Object)((Object)dto));
            Date date = rakebackRecord.getCreateTime();
            if (null != date) {
                String createTime = DateFormat.getDateInstance(2).format(date);
                dto.setCreateOrderTime(createTime);
            }
            id = rakebackRecord.getUserId();
            userIdList.add(id);
            dtos.add(dto);
        }
        List userList = this.userMapper.getUserListByUserIds(null, userIdList);
        HashMap<Integer, String> idMap = new HashMap<Integer, String>();
        for (AtinUser user : userList) {
            idMap.put(user.getId(), user.getNickname());
        }
        for (RakebackRecordDto dto : dtos) {
            id = dto.getUserId();
            if (id == null) continue;
            String nickName = (String)idMap.get(id);
            dto.setNickname(nickName);
        }
        result.setResults(dtos);
        return result;
    }

    @Override
    public List<RakebackRecordDto> findUserInfoByInViteUserId(Integer inviteUserId) {
        Integer id;
        ArrayList<RakebackRecordDto> dtos = new ArrayList<RakebackRecordDto>();
        List rakebackRecordList = this.rakebackRecordMapper.findRecordListById(inviteUserId);
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        for (AtinRakebackRecord rakebackRecord : rakebackRecordList) {
            RakebackRecordDto dto = new RakebackRecordDto();
            BeanUtils.copyProperties((Object)rakebackRecord, (Object)((Object)dto));
            Date date = rakebackRecord.getCreateTime();
            if (null != date) {
                String createTime = DateFormat.getDateInstance(2).format(date);
                dto.setCreateOrderTime(createTime);
            }
            if (null != (id = rakebackRecord.getUserId())) {
                userIdList.add(id);
            }
            dtos.add(dto);
        }
        if (userIdList != null && userIdList.size() > 0) {
            HashMap<Integer, String> idMap = new HashMap<Integer, String>();
            List userList = this.userMapper.getUserListByUserIds(null, userIdList);
            for (AtinUser user : userList) {
                idMap.put(user.getId(), user.getNickname());
            }
            for (RakebackRecordDto dto : dtos) {
                id = dto.getUserId();
                if (id == null) continue;
                String nickName = (String)idMap.get(id);
                dto.setNickname(nickName);
            }
        }
        return dtos;
    }

    @Override
    public List<RakebackRecordDto> findRecordListByUserId(Integer userId) {
        List rakebackRecordList = this.rakebackRecordMapper.findRecordListById(userId);
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        AtinUserInfo userInfo = this.userInfoMapper.findUserInfoByOpenId(user.getOpenid());
        ArrayList<RakebackRecordDto> rakebackRecordDtoList = new ArrayList<RakebackRecordDto>();
        for (AtinRakebackRecord atinRakebackRecord : rakebackRecordList) {
            RakebackRecordDto rackBackRecordDto = new RakebackRecordDto();
            BeanUtil.quickCopy((Object)atinRakebackRecord, (Object)((Object)rackBackRecordDto));
            if (null != atinRakebackRecord) {
                AtinOrder order = (AtinOrder)this.orderMapper.selectByPrimaryKey(atinRakebackRecord.getOrderId());
                Integer policyId = order.getPolicyId();
                AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(policyId);
                String insuCom = policy.getInsuCom();
                rackBackRecordDto.setInsuCom(insuCom);
                AtinInsurer insurer = ServiceUtil.getInsurerByCode(insuCom);
                if (null != insurer) {
                    rackBackRecordDto.setInsurerName(insurer.getAbbreviation());
                }
            }
            rackBackRecordDto.setNickname(userInfo.getNickname());
            rackBackRecordDto.setUsername(user.getUsername());
            rakebackRecordDtoList.add(rackBackRecordDto);
        }
        return rakebackRecordDtoList;
    }
}

