/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.zhlh.Tiny.constant.AIConstants;
import com.zhlh.Tiny.exception.CommonException;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.Tiny.util.NumberUtil;
import com.zhlh.karma.domain.model.AtinAgencySupportInsuc;
import com.zhlh.karma.domain.model.AtinAgentRate;
import com.zhlh.karma.domain.model.AtinCoverage;
import com.zhlh.karma.domain.model.AtinInsurer;
import com.zhlh.karma.domain.model.AtinOrder;
import com.zhlh.karma.domain.model.AtinOrderAction;
import com.zhlh.karma.domain.model.AtinOrderRoles;
import com.zhlh.karma.domain.model.AtinPayLog;
import com.zhlh.karma.domain.model.AtinPolicy;
import com.zhlh.karma.domain.model.AtinPolicyCoverage;
import com.zhlh.karma.domain.model.AtinQuotation;
import com.zhlh.karma.domain.model.AtinQuotationCoverage;
import com.zhlh.karma.domain.model.AtinRakebackRateConfig;
import com.zhlh.karma.domain.model.AtinUser;
import com.zhlh.karma.domain.model.AtinVehicle;
import com.zhlh.karma.domain.model.AtinVehicleRoles;
import com.zhlh.karma.dto.QuotationCoverageDto;
import com.zhlh.karma.dto.QuotationDto;
import com.zhlh.karma.dto.QuotePriceResultDto;
import com.zhlh.karma.mapper.AtinAgencyMapper;
import com.zhlh.karma.mapper.AtinAgencySupportInsucMapper;
import com.zhlh.karma.mapper.AtinAgentRateMapper;
import com.zhlh.karma.mapper.AtinOrderActionMapper;
import com.zhlh.karma.mapper.AtinOrderMapper;
import com.zhlh.karma.mapper.AtinOrderRolesMapper;
import com.zhlh.karma.mapper.AtinPayLogMapper;
import com.zhlh.karma.mapper.AtinPolicyCoverageMapper;
import com.zhlh.karma.mapper.AtinPolicyMapper;
import com.zhlh.karma.mapper.AtinQuotationCoverageMapper;
import com.zhlh.karma.mapper.AtinQuotationMapper;
import com.zhlh.karma.mapper.AtinRakebackRateConfigMapper;
import com.zhlh.karma.mapper.AtinUserMapper;
import com.zhlh.karma.mapper.AtinVehicleMapper;
import com.zhlh.karma.mapper.AtinVehicleRolesMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.service.QuotationService;
import com.zhlh.karma.service.common.ServiceUtil;
import com.zhlh.karma.service.constant.ChannelConstants;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import com.zhlh.zeus.api.EndDateRService;
import com.zhlh.zeus.api.QuotePriceRService;
import com.zhlh.zeus.dto.endDate.EndDateReqDto;
import com.zhlh.zeus.dto.endDate.EndDateResDto;
import com.zhlh.zeus.dto.quote.CoverageDataDto;
import com.zhlh.zeus.dto.quote.CustomerDataDto;
import com.zhlh.zeus.dto.quote.QuotePriceReqDto;
import com.zhlh.zeus.dto.quote.QuotePriceResDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuotationServiceImpl
extends BaseServiceImpl<AtinQuotation>
implements QuotationService {
    private static final Logger log = LoggerFactory.getLogger(QuotationServiceImpl.class);
    @Autowired
    EndDateRService endDateRService;
    @Autowired
    private AtinQuotationMapper quotationMapper;
    @Autowired
    private AtinQuotationCoverageMapper quotationCoverageMapper;
    @Autowired
    private QuotePriceRService quotePriceRService;
    @Autowired
    private AtinPolicyMapper policyMapper;
    @Autowired
    private AtinPolicyCoverageMapper policyCoverageMapper;
    @Autowired
    private AtinOrderRolesMapper orderRolesMapper;
    @Autowired
    private AtinPayLogMapper payLogMapper;
    @Autowired
    private AtinOrderMapper lbOrderMapper;
    @Autowired
    private AtinOrderActionMapper orderActionMapper;
    @Autowired
    private AtinVehicleRolesMapper vehicleRolesMapper;
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private AtinVehicleMapper vehicleMapper;
    @Autowired
    private AtinAgentRateMapper agentRateMapper;
    @Autowired
    private AtinAgencySupportInsucMapper agencySupportInsucMapper;
    @Autowired
    private AtinAgencyMapper agencyMapper;
    @Autowired
    private AtinRakebackRateConfigMapper atinRakebackRateConfigMapper;

    @Override
    public BaseMapper<AtinQuotation> getBaseMapper() {
        return this.quotationMapper;
    }

    @Override
    public int isChangedQuotePriceReqDto(Integer userId, QuotePriceReqDto quotePriceReqDto) {
        String quoteQueryStr;
        QuotePriceReqDto quotePriceReqDtoBaseCustom = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        String quoteQueryBaseCustonStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDtoBaseCustom);
        if (quoteQueryBaseCustonStr.equals(quoteQueryStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDto))) {
            return 0;
        }
        return 1;
    }

    @Override
    public QuotationDto getQuotationDtoByVehicleId(Integer vehicleId, Integer userId) {
        AtinVehicle vehicleInfo = (AtinVehicle)this.vehicleMapper.selectByPrimaryKey(vehicleId);
        AtinVehicle vehicle = (AtinVehicle)this.vehicleMapper.selectByPrimaryKey(vehicleId);
        if (null != vehicle) {
            String queryLicenseNo;
            String licenseNo = vehicle.getLicenseNo();
            QuotePriceReqDto quotePriceReqDtoCustom = ServiceUtil.getQuoteReqDtoFromRedis(userId);
            if (null != quotePriceReqDtoCustom && CommonUtil.isNotEmpty((String)(queryLicenseNo = quotePriceReqDtoCustom.getLicenseNo())) && queryLicenseNo.equals(licenseNo)) {
                log.info("\u53d6\u51fa\u7f13\u5b58\u5404\u7c7b\u8bf7\u6c42\u53c2\u6570");
                QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDtoCustom);
                return quotationDto;
            }
        }
        QuotePriceReqDto quotePriceReqDto = this.vehicleToQuotePriceReqDto(vehicleInfo);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        log.info("\u7f13\u5b58\u7a7a\u7684\u8bf7\u6c42\u53c2\u6570");
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        return quotationDto;
    }

    private QuotePriceReqDto vehicleToQuotePriceReqDto(AtinVehicle vehicleInfo) {
        QuotePriceReqDto quotePriceReqDto = new QuotePriceReqDto();
        BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
        ArrayList<CoverageDataDto> coverageDataDtoList = new ArrayList<CoverageDataDto>();
        CoverageDataDto coverageDataDto = new CoverageDataDto();
        coverageDataDto.setCoverageCode("BZ");
        coverageDataDto.setIsDeductibleChoice(Integer.valueOf(1));
        coverageDataDtoList.add(coverageDataDto);
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        EndDateResDto endDateResDto = this.queryEndDate(vehicleInfo);
        Date tciStartDate = DateUtil.parseDate((String)endDateResDto.getTciLastEndDate(), (String)"yyyy-MM-dd");
        tciStartDate = DateUtil.addDays((Date)tciStartDate, (int)1);
        quotePriceReqDto.setTciStartDate(DateUtil.formatDate((Date)tciStartDate));
        Date vciStartDate = DateUtil.parseDate((String)endDateResDto.getVciLastEndDate(), (String)"yyyy-MM-dd");
        vciStartDate = DateUtil.addDays((Date)vciStartDate, (int)1);
        quotePriceReqDto.setVciStartDate(DateUtil.formatDate((Date)vciStartDate));
        return quotePriceReqDto;
    }

    @Override
    public EndDateResDto queryEndDate(AtinVehicle vehicleInfo) {
        EndDateReqDto endDateReqDto = new EndDateReqDto();
        BeanUtil.quickCopy((Object)vehicleInfo, (Object)endDateReqDto);
        endDateReqDto.setInsuCom("I00002");
        endDateReqDto.setChannel(ChannelConstants.CHANNEL);
        endDateReqDto.setPartner("zhlh");
        endDateReqDto.setOrigin(ChannelConstants.CHANNEL);
        endDateReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(endDateReqDto.getLicenseNo()));
        log.info("\u4e0a\u5e74\u6b62\u671f\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a" + JsonUtil.beanToJSON((Object)endDateReqDto));
        EndDateResDto endDateResDto = this.endDateRService.queryPolicyEndDate(endDateReqDto);
        log.info("\u4e0a\u5e74\u6b62\u671f\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a" + JsonUtil.beanToJSON((Object)endDateResDto));
        EndDateResDto endDateResDto2 = endDateResDto = endDateResDto == null ? new EndDateResDto() : endDateResDto;
        if (CommonUtil.isEmpty((String)endDateResDto.getTciLastEndDate())) {
            endDateResDto.setTciLastEndDate(DateUtil.getCurrentDate());
        }
        if (CommonUtil.isEmpty((String)endDateResDto.getVciLastEndDate())) {
            endDateResDto.setVciLastEndDate(DateUtil.getCurrentDate());
        }
        return endDateResDto;
    }

    @Override
    public EndDateResDto queryStartDate(AtinVehicle vehicleInfo) {
        EndDateResDto endDateResDto = this.queryEndDate(vehicleInfo);
        endDateResDto = endDateResDto == null ? new EndDateResDto() : endDateResDto;
        Date tciStartDate = DateUtil.parseDate((String)endDateResDto.getTciLastEndDate(), (String)"yyyy-MM-dd");
        tciStartDate = DateUtil.addDays((Date)tciStartDate, (int)1);
        endDateResDto.setTciLastEndDate(DateUtil.formatDate((Date)tciStartDate));
        Date vciStartDate = DateUtil.parseDate((String)endDateResDto.getVciLastEndDate(), (String)"yyyy-MM-dd");
        vciStartDate = DateUtil.addDays((Date)vciStartDate, (int)1);
        endDateResDto.setVciLastEndDate(DateUtil.formatDate((Date)vciStartDate));
        return endDateResDto;
    }

    @Override
    public QuotationDto quotePriceReqDtoToQuotationDto(QuotePriceReqDto quotePriceReqDto) {
        QuotationDto quotationDto = new QuotationDto();
        BeanUtil.quickCopy((Object)quotePriceReqDto, (Object)((Object)quotationDto));
        quotationDto.setTciStartDate(DateUtil.parseDate((String)quotePriceReqDto.getTciStartDate(), (String)"yyyy-MM-dd"));
        quotationDto.setVciStartDate(DateUtil.parseDate((String)quotePriceReqDto.getVciStartDate(), (String)"yyyy-MM-dd"));
        ArrayList<QuotationCoverageDto> coverageList = new ArrayList<QuotationCoverageDto>();
        for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
            QuotationCoverageDto quotationCoverageDto = new QuotationCoverageDto();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)quotationCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(quotationCoverageDto.getCoverageCode());
            if (null == coverage) continue;
            quotationCoverageDto.setName(coverage.getName());
            quotationCoverageDto.setAmount(new BigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getAmount()))));
            quotationCoverageDto.setUnimount(new BigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getUnitAmount()))));
            quotationCoverageDto.setModelCode(CommonUtil.isNotEmpty((String)coverageDataDto.getModeCode()) ? new Integer(coverageDataDto.getModeCode()) : 0);
            quotationCoverageDto.setBenchmarkPremium(new BigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getBenchmarkPremium()))));
            quotationCoverageDto.setPremium(new BigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getPremium()))));
            quotationCoverageDto.setQuantity(coverageDataDto.getQuantity());
            coverageList.add(quotationCoverageDto);
        }
        quotationDto.setCoverageList(coverageList);
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoBySubmitCoverage(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        List coverageDataDtoList = (quotePriceReqDto = this.formatQuotePriceReqDto(quotePriceReqDto, userId)).getCoverageDataDtoList();
        if (null != coverageDataDtoList) {
            for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
                Integer isDeductibleChoice = coverageDataDto.getIsDeductibleChoice();
                if (null == isDeductibleChoice || isDeductibleChoice != 1) continue;
                CoverageDataDto coverageDataDtoUsual = new CoverageDataDto();
                coverageDataDtoUsual.setCoverageCode("M");
                coverageDataDtoUsual.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual);
                break;
            }
        }
        for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
            coverageDataDto.setAmount(Integer.valueOf(Integer.parseInt(NumberUtil.changeYToF((String)String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getAmount()))))));
            coverageDataDto.setUnitAmount(Integer.valueOf(Integer.parseInt(NumberUtil.changeYToF((String)String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getUnitAmount()))))));
        }
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        return quotationDto;
    }

    private QuotePriceReqDto formatQuotePriceReqDto(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        quotePriceReqDto.setTciStartDate(ServiceUtil.formatStartDate(quotePriceReqDto.getTciStartDate()));
        quotePriceReqDto.setVciStartDate(ServiceUtil.formatStartDate(quotePriceReqDto.getVciStartDate()));
        QuotePriceReqDto redisQuotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        AtinVehicle vehicleInfo = new AtinVehicle();
        if (null != redisQuotePriceReqDto) {
            BeanUtil.quickCopy((Object)redisQuotePriceReqDto, (Object)vehicleInfo);
            BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
            if (null != vehicleInfo) {
                BeanUtil.quickCopy((Object)vehicleInfo, (Object)quotePriceReqDto);
            }
        }
        return quotePriceReqDto;
    }

    @Override
    public QuotationDto getQuotationDtoByOrderId(Integer orderId) {
        AtinOrder lbOrder = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        QuotationDto quotationDto = this.getQuotationDtoByQuotationId(policy.getQuotationId());
        quotationDto.setId(policy.getQuotationId());
        return quotationDto;
    }

    @Override
    public int isChangedQuotePriceReqDto(Integer orderId) {
        AtinOrder lbOrder = (AtinOrder)this.lbOrderMapper.selectByPrimaryKey(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotationId(policy.getQuotationId());
        return this.isChangedQuotePriceReqDto(lbOrder.getUserId(), quotePriceReqDto);
    }

    @Override
    public QuotationDto getQuotationDtoByQuotationId(Integer quotationId) {
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotationId(quotationId);
        QuotationDto quotationDto = this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
        ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, ((AtinQuotation)this.getByID(quotationId)).getUserId());
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationDtoFromRedis(Integer userId) {
        QuotePriceReqDto quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        if (quotePriceReqDto == null || quotePriceReqDto.getCoverageDataDtoList() == null || quotePriceReqDto.getCoverageDataDtoList().size() == 0 || CommonUtil.isEmpty((String)quotePriceReqDto.getLicenseNo())) {
            quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        }
        if (null != quotePriceReqDto) {
            ServiceUtil.saveQuoteReqDtoRedis(quotePriceReqDto, userId);
        }
        return this.quotePriceReqDtoToQuotationDto(quotePriceReqDto);
    }

    private QuotePriceReqDto getQuotePriceReqDtoByQuotationId(Integer quotationId) {
        QuotePriceReqDto quotePriceReqDto = new QuotePriceReqDto();
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        BeanUtil.quickCopy((Object)quotation, (Object)quotePriceReqDto);
        quotePriceReqDto.setTciStartDate(DateUtil.formatDate((Date)quotation.getTciStartDate()));
        quotePriceReqDto.setVciStartDate(DateUtil.formatDate((Date)quotation.getVciStartDate()));
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        List<CoverageDataDto> coverageDataDtoList = this.quotationCoverageListToCoverageDataDtoList(quotationCoverageList);
        quotePriceReqDto.setCoverageDataDtoList(coverageDataDtoList);
        return quotePriceReqDto;
    }

    private List<CoverageDataDto> quotationCoverageListToCoverageDataDtoList(List<AtinQuotationCoverage> quotationCoverageList) {
        ArrayList<CoverageDataDto> coverageDataDtoList = new ArrayList<CoverageDataDto>();
        for (AtinQuotationCoverage quotationCoverage : quotationCoverageList) {
            CoverageDataDto coverageDataDto = new CoverageDataDto();
            coverageDataDto.setAmount(Integer.valueOf(NumberUtil.changeFToInt((String)quotationCoverage.getAmount().toPlainString())));
            coverageDataDto.setUnitAmount(Integer.valueOf(NumberUtil.changeFToInt((String)quotationCoverage.getUnimount().toPlainString())));
            coverageDataDto.setIsDeductibleChoice(quotationCoverage.getIsDeductibleChoice());
            coverageDataDto.setModeCode(quotationCoverage.getModelCode().toString());
            coverageDataDto.setCoverageCode(quotationCoverage.getCoverageCode());
            coverageDataDtoList.add(coverageDataDto);
        }
        return coverageDataDtoList;
    }

    @Override
    public QuotationDto quotePrice(Integer userId, String insuCom, Integer agencyId) {
        QuotationDto quotationDto;
        QuotePriceReqDto quotePriceReqDto = ServiceUtil.getQuoteReqDtoFromRedis(userId);
        if (null == quotePriceReqDto) {
            log.info("\u7f13\u5b58\u53d6\u51fa\u7684\u8be2\u4ef7\u53c2\u6570dto\u4e3a\u7a7a");
        } else {
            String json = JsonUtil.beanToJSON((Object)quotePriceReqDto);
            log.info("\u7f13\u5b58\u53d6\u51fa\u7684\u8be2\u4ef7\u53c2\u6570dto\u7684json\u4e3a" + json);
        }
        if (null == quotePriceReqDto || CommonUtil.isEmpty((String)quotePriceReqDto.getLicenseNo())) {
            throw new CommonException(1, "\u672a\u9009\u62e9\u9669\u79cd,\u65e0\u62a5\u4ef7");
        }
        if (!ServiceUtil.isSupportByInsurerCode(insuCom, quotePriceReqDto.getLicenseNo()).booleanValue()) {
            throw new CommonException(1, "\u672c\u5730\u533a\u6682\u4e0d\u652f\u6301");
        }
        String quoteQueryStr = ServiceUtil.getQuoteQueryStr(quotePriceReqDto);
        QuotePriceResultDto resultDto = ServiceUtil.getQuoteResultDtoFromRedis(userId, agencyId);
        if (resultDto != null && resultDto.getQuoteQueryStr().equals(quoteQueryStr) && CommonUtil.isNotEmpty(resultDto.getResultMap()) && resultDto.getResultMap().get(insuCom) != null) {
            log.info("\u4eceredis\u4e2d\u53d6\u51fa\u8be2\u4ef7\u7ed3\u679c");
            QuotePriceResDto quotePriceResDto = resultDto.getResultMap().get(insuCom);
            AtinQuotation atinQuotation = this.quotationMapper.getQuotationByQuoteNo(quotePriceResDto.getQuoteNo());
            List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(atinQuotation.getId());
            quotationDto = this.quotationToDto(atinQuotation, quotationCoverageList);
        } else {
            log.info("\u91cd\u65b0\u8be2\u4ef7");
            quotePriceReqDto.setInsuCom(insuCom);
            quotePriceReqDto.setChannel(ChannelConstants.CHANNEL);
            quotePriceReqDto.setOrigin(ChannelConstants.CHANNEL);
            quotePriceReqDto.setPartner("zhlh");
            quotePriceReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo()));
            if (null != quotePriceReqDto) {
                log.info(insuCom + "\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto:" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
            } else {
                log.info(insuCom + "\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto\u4e3a\u7a7a");
            }
            QuotePriceResDto quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
            if (null != quotePriceResDto) {
                log.info("\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto:" + JsonUtil.beanToJSON((Object)quotePriceResDto));
            } else {
                log.info("\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto\u4e3a\u7a7a");
            }
            if (quotePriceResDto == null || quotePriceResDto.getErrCode() == null || quotePriceResDto.getErrCode() != 0) {
                throw new CommonException(1, quotePriceResDto.getErrMsg());
            }
            String modelCodeReq = "";
            for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
                if (!coverageDataDto.getCoverageCode().equals("F")) continue;
                modelCodeReq = coverageDataDto.getModeCode();
            }
            for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
                if (!coverageDataDto.getCoverageCode().equals("F")) continue;
                String modelCodeRes = coverageDataDto.getModeCode();
                if (CommonUtil.isEmpty((String)modelCodeRes)) {
                    coverageDataDto.setModeCode(modelCodeReq);
                    continue;
                }
                if (!modelCodeRes.equals("0")) continue;
                coverageDataDto.setModeCode(modelCodeReq);
            }
            quotationDto = this.saveQuotePriceResDtoToQuotation(null, quotePriceResDto, quotePriceReqDto, userId, agencyId);
            if (resultDto == null || !resultDto.getQuoteQueryStr().equals(quoteQueryStr)) {
                resultDto = new QuotePriceResultDto();
                resultDto.setQuoteQueryStr(quoteQueryStr);
                resultDto.setResultMap(new HashMap<String, QuotePriceResDto>());
            }
            resultDto.getResultMap().put(insuCom, quotePriceResDto);
            ServiceUtil.saveQuoteResultDtoToRedis(resultDto, userId, agencyId);
        }
        return quotationDto;
    }

    @Override
    public void saveOrUpdateRoles(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        AtinOrderRoles orderRoles = new AtinOrderRoles();
        orderRoles.setApplicantName(quotePriceReqDto.getPolicyHolderData().getName());
        orderRoles.setApplicantMobile(quotePriceReqDto.getPolicyHolderData().getMobile());
        orderRoles.setApplicantCertNo(quotePriceReqDto.getPolicyHolderData().getCertNo());
        orderRoles.setApplicantEmail(quotePriceReqDto.getPolicyHolderData().getEmail());
        orderRoles.setInsuredName(quotePriceReqDto.getInsurantData().getName());
        orderRoles.setInsuredMobile(quotePriceReqDto.getInsurantData().getMobile());
        orderRoles.setInsuredCertNo(quotePriceReqDto.getInsurantData().getCertNo());
        orderRoles.setInsuredEmail(quotePriceReqDto.getInsurantData().getEmail());
        orderRoles.setOwnerName(quotePriceReqDto.getOwnerData().getName());
        orderRoles.setOwnerCertNo(quotePriceReqDto.getOwnerData().getCertNo());
        this.saveOrUpdateVehicleRoles(orderRoles, userId, quotePriceReqDto.getLicenseNo());
    }

    @Override
    public QuotationDto quotePriceBySaas(QuotePriceReqDto quotePriceReqDto, Integer userId, String insuCom, Integer agencyId) {
        quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(1));
        quotePriceReqDto.getOwnerData().setPersonType("0");
        quotePriceReqDto.getInsurantData().setPersonType("1");
        quotePriceReqDto.getPolicyHolderData().setPersonType("2");
        List coverageDataDtoList = quotePriceReqDto.getCoverageDataDtoList();
        if (null != coverageDataDtoList) {
            for (CoverageDataDto coverageDataDto : coverageDataDtoList) {
                Integer isDeductibleChoice = coverageDataDto.getIsDeductibleChoice();
                if (null == isDeductibleChoice || isDeductibleChoice != 1) continue;
                CoverageDataDto coverageDataDtoUsual = new CoverageDataDto();
                coverageDataDtoUsual.setCoverageCode("M");
                coverageDataDtoUsual.setIsDeductibleChoice(Integer.valueOf(1));
                coverageDataDtoList.add(coverageDataDtoUsual);
                break;
            }
        }
        if (AIConstants.InsuCom.INSURE_HA.getValue().equals(quotePriceReqDto.getInsuCom())) {
            this.cancelOrder(AIConstants.InsuCom.INSURE_HA.getValue(), quotePriceReqDto.getLicenseNo());
        }
        log.info("\u62a5\u4ef7\u8bf7\u6c42\u53c2\u6570" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
        QuotePriceResDto quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
        log.info("\u62a5\u4ef7\u8fd4\u56de\u7ed3\u679c" + JsonUtil.beanToJSON((Object)quotePriceResDto));
        if (quotePriceResDto == null || quotePriceResDto.getErrCode() == null || quotePriceResDto.getErrCode() != 0) {
            if (21002 == quotePriceResDto.getErrCode()) {
                String errorMessage = "";
                if (quotePriceResDto != null) {
                    for (CoverageDataDto coverage : quotePriceResDto.getCoverageList()) {
                        if (0 != coverage.getIsApprove()) continue;
                        errorMessage = errorMessage + coverage.getReason();
                    }
                    throw new CommonException(1, errorMessage);
                }
            } else {
                throw new CommonException(1, quotePriceResDto.getErrMsg());
            }
        }
        String modelCodeRes = "";
        String modelCodeReq = "";
        if (null != quotePriceReqDto) {
            for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
                if (!coverageDataDto.getCoverageCode().equals("F")) continue;
                modelCodeReq = coverageDataDto.getModeCode();
            }
        }
        for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
            if (!coverageDataDto.getCoverageCode().equals("F")) continue;
            modelCodeRes = coverageDataDto.getModeCode();
            if (CommonUtil.isEmpty((String)modelCodeRes)) {
                coverageDataDto.setModeCode(modelCodeReq);
                continue;
            }
            if (!modelCodeRes.equals("0")) continue;
            coverageDataDto.setModeCode(modelCodeReq);
        }
        QuotationDto quotationDto = this.saveQuotePriceResDtoToQuotation(null, quotePriceResDto, quotePriceReqDto, userId, agencyId);
        AtinVehicleRoles vehicleRoles = new AtinVehicleRoles();
        vehicleRoles.setUserId(userId);
        vehicleRoles.setLicenseNo(quotePriceReqDto.getLicenseNo());
        vehicleRoles.setApplicantName(quotePriceReqDto.getPolicyHolderData().getName());
        vehicleRoles.setApplicantMobile(quotePriceReqDto.getPolicyHolderData().getMobile());
        vehicleRoles.setApplicantCertNo(quotePriceReqDto.getPolicyHolderData().getCertNo());
        vehicleRoles.setApplicantCertType("01");
        vehicleRoles.setApplicantEmail(quotePriceReqDto.getPolicyHolderData().getEmail());
        vehicleRoles.setInsuredName(quotePriceReqDto.getInsurantData().getName());
        vehicleRoles.setInsuredMobile(quotePriceReqDto.getInsurantData().getMobile());
        vehicleRoles.setInsuredCertNo(quotePriceReqDto.getInsurantData().getCertNo());
        vehicleRoles.setInsuredCertType("01");
        vehicleRoles.setInsuredEmail(quotePriceReqDto.getInsurantData().getEmail());
        vehicleRoles.setOwnerName(quotePriceReqDto.getOwnerData().getName());
        vehicleRoles.setOwnerCertNo(quotePriceReqDto.getOwnerData().getCertNo());
        vehicleRoles.setOwnerCertType("01");
        vehicleRoles.setQuotationId(quotationDto.getId());
        this.vehicleRolesMapper.insertSelective((Object)vehicleRoles);
        return quotationDto;
    }

    @Override
    public QuotationDto saveQuotePriceResult(AtinQuotation quotationParam, QuotePriceResDto quotePriceResDto, QuotePriceReqDto quotePriceReqDto, Integer userId, Integer agencyId) {
        return this.saveQuotePriceResDtoToQuotation(quotationParam, quotePriceResDto, quotePriceReqDto, userId, agencyId);
    }

    private QuotationDto saveQuotePriceResDtoToQuotation(AtinQuotation quotationParam, QuotePriceResDto quotePriceResDto, QuotePriceReqDto quotePriceReqDto, Integer userId, Integer agencyId) {
        BigDecimal tciAgencyDiscount;
        BigDecimal agencyDiscount;
        AtinQuotation quotation = new AtinQuotation();
        BeanUtil.quickCopy((Object)quotePriceResDto, (Object)quotation);
        quotation.setChannel(ChannelConstants.CHANNEL);
        quotation.setUserId(userId);
        quotation.setAgencyPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getPremium())));
        quotation.setSumTravelTax(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getSumTravelTax())));
        quotation.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getBenchmarkPremium())));
        quotation.setTciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getTciPremium())));
        quotation.setVciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getVciPremium())));
        quotation.setTciStartDate(this.formatToDate(quotePriceReqDto.getTciStartDate()));
        quotation.setVciStartDate(this.formatToDate(quotePriceReqDto.getVciStartDate()));
        quotation.setUniqueVehicleCode(quotePriceReqDto.getUniqueVehicleCode());
        BeanUtil.quickCopy((Object)quotePriceReqDto, (Object)quotation);
        quotation.setAgencyId(agencyId);
        AtinAgencySupportInsuc agencySupportInsuc = ServiceUtil.getAgencySupportInsuc(quotation.getInsuCom(), quotation.getLicenseNo(), agencyId);
        Integer id = agencySupportInsuc.getId();
        AtinAgentRate agentRate = this.agentRateMapper.getAgenyDiscount(userId, id);
        String cityCode = ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo());
        if (agentRate == null) {
            log.info("agencyId: " + agencyId + " InsuCom: " + quotation.getInsuCom() + " cityCode: " + cityCode);
            AtinAgencySupportInsuc supportInsuc = this.agencySupportInsucMapper.getAgencyInsurerCityRate(agencyId, quotation.getInsuCom(), cityCode);
            if (supportInsuc == null) {
                agencyDiscount = new BigDecimal("0");
                tciAgencyDiscount = new BigDecimal("0");
            } else {
                log.info("supportInsuc {}", (Object)supportInsuc.getDiscount());
                agencyDiscount = supportInsuc.getDiscount();
                tciAgencyDiscount = supportInsuc.getTciDiscount();
            }
        } else {
            agencyDiscount = agentRate.getDiscount();
            tciAgencyDiscount = agentRate.getTciDiscount();
        }
        quotation.setAgencyDiscount(agencyDiscount);
        quotation.setTciAgencyDiscount(tciAgencyDiscount);
        quotation.setQueryNo(quotePriceResDto.getQuoteNo());
        quotation.setInsuStartDate(new Date());
        if (null != quotationParam) {
            BigDecimal agentDiscount = quotationParam.getAgentDiscount();
            agencyDiscount = quotationParam.getAgencyDiscount();
            quotation.setAgencyDiscount(agencyDiscount);
            quotation.setAgentDiscount(agentDiscount);
            BigDecimal agentPremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agentDiscount));
            agentPremium = agentPremium.add(quotation.getTciPremium().multiply(new BigDecimal(1).subtract(tciAgencyDiscount)));
            agentPremium.add(quotation.getSumTravelTax());
            quotation.setAgentPremium(agentPremium);
            BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount().subtract(agentDiscount));
            rackBackPremium = rackBackPremium.add(quotation.getTciPremium().multiply(quotation.getTciAgencyDiscount().subtract(tciAgencyDiscount)));
            rackBackPremium = rackBackPremium.setScale(2, 4);
            quotation.setRackbackPremium(rackBackPremium);
        } else {
            quotation.setAgentPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getPremium())));
        }
        BigDecimal netFeePremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agencyDiscount));
        netFeePremium = netFeePremium.add(quotation.getTciPremium().multiply(new BigDecimal(1).subtract(tciAgencyDiscount)));
        netFeePremium = netFeePremium.add(quotation.getSumTravelTax());
        quotation.setNetFeePremium(netFeePremium);
        this.insert(quotation);
        ArrayList<AtinQuotationCoverage> quotationCoverageList = new ArrayList<AtinQuotationCoverage>();
        for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
            AtinQuotationCoverage quotationCoverage = new AtinQuotationCoverage();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)quotationCoverage);
            quotationCoverage.setReason(CommonUtil.isEmpty((String)coverageDataDto.getReason()) ? "" : coverageDataDto.getReason());
            quotationCoverage.setQuantity(NumberUtil.nullToZero((Integer)coverageDataDto.getQuantity()));
            quotationCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getAmount()))));
            quotationCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getUnitAmount()))));
            quotationCoverage.setModelCode(Integer.valueOf(CommonUtil.isNotEmpty((String)coverageDataDto.getModeCode()) ? new Integer(coverageDataDto.getModeCode()) : 0));
            quotationCoverage.setPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getPremium()))));
            quotationCoverage.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getBenchmarkPremium()))));
            quotationCoverage.setDiscount(new BigDecimal(0));
            quotationCoverage.setQuotationId(quotation.getId());
            quotationCoverageList.add(quotationCoverage);
        }
        List coverageDtoList = quotePriceReqDto.getCoverageDataDtoList();
        this.quotationCoverageMapper.batchInsert(quotationCoverageList);
        return this.quotationToDto(quotation, quotationCoverageList);
    }

    private QuotationDto quotationToDto(AtinQuotation quotation, List<AtinQuotationCoverage> quotationCoverageList) {
        QuotationDto quotationDto = new QuotationDto();
        BeanUtil.quickCopy((Object)quotation, (Object)((Object)quotationDto));
        AtinInsurer insurer = ServiceUtil.getInsurerByCode(quotation.getInsuCom());
        quotationDto.setInsuComName(insurer.getAbbreviation());
        ArrayList<QuotationCoverageDto> coverageList = new ArrayList<QuotationCoverageDto>();
        for (AtinQuotationCoverage quotationCoverage : quotationCoverageList) {
            QuotationCoverageDto quotationCoverageDto = new QuotationCoverageDto();
            BeanUtil.quickCopy((Object)quotationCoverage, (Object)quotationCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(quotationCoverageDto.getCoverageCode());
            quotationCoverageDto.setName(coverage.getName());
            quotationCoverageDto.setAssortment(coverage.getAssortment());
            coverageList.add(quotationCoverageDto);
        }
        quotationDto.setCoverageList(coverageList);
        return quotationDto;
    }

    @Override
    public Integer preciseQuotePrice(AtinOrderRoles orderRoles, Integer quotationId, AtinUser user, Integer agencyId, String isElcInvoice) throws CommonException {
        orderRoles = this.changeOrderRoles(orderRoles, user);
        orderRoles.setInsuredEmail(orderRoles.getApplicantEmail());
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        QuotePriceReqDto quotePriceReqDto = this.getQuotePriceReqDtoByQuotationId(quotationId);
        quotePriceReqDto = this.setOrderRolesToQuotePriceReqDto(quotePriceReqDto, orderRoles);
        quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(1));
        if (CommonUtil.isNotEmpty((String)isElcInvoice) && isElcInvoice.length() > 1) {
            quotePriceReqDto.setIsElcInvoice(isElcInvoice.substring(1, 2));
        } else {
            quotePriceReqDto.setIsElcInvoice(isElcInvoice);
        }
        this.saveOrUpdateVehicleRoles(orderRoles, user.getId(), quotePriceReqDto.getLicenseNo());
        quotePriceReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(quotePriceReqDto.getLicenseNo()));
        quotePriceReqDto.setPartner("zhlh");
        quotePriceReqDto.setOrigin(ChannelConstants.CHANNEL);
        quotePriceReqDto.setChannel(ChannelConstants.CHANNEL);
        if (null != quotePriceReqDto) {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto:" + JsonUtil.beanToJSON((Object)quotePriceReqDto));
        } else {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceReqDto\u4e3a\u7a7a");
        }
        QuotePriceResDto quotePriceResDto = this.quotePriceRService.quotePrice(quotePriceReqDto);
        if (null != quotePriceResDto) {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto:" + JsonUtil.beanToJSON((Object)quotePriceResDto));
        } else {
            log.info("\u518d\u6b21\u7cbe\u786e\u8be2\u4ef7\u8bf7\u6c42\u53c2\u6570quotePriceResDto\u4e3a\u7a7a");
        }
        log.info("\u6b63\u5728\u8fdb\u884c\u7cbe\u786e\u62a5\u4ef7");
        if (quotePriceResDto.getErrCode() != 0) {
            throw new CommonException(quotePriceResDto.getErrCode().intValue(), quotePriceResDto.getErrMsg());
        }
        this.orderRolesMapper.insertSelective((Object)orderRoles);
        QuotationDto quotationDto = this.saveQuotePriceResDtoToQuotation(quotation, quotePriceResDto, quotePriceReqDto, user.getId(), agencyId);
        AtinPolicy policy = this.saveQuotePriceResDtoToPolicy(quotePriceResDto, quotationDto.getId());
        AtinOrder lbOrder = this.saveLbOrder(policy, user, orderRoles, agencyId);
        return lbOrder.getId();
    }

    private void saveOrUpdateVehicleRoles(AtinOrderRoles orderRoles, Integer userId, String licenseNo) {
        AtinVehicleRoles vehicleRoles = this.vehicleRolesMapper.selectByUserIdAndLicenseNo(userId, licenseNo);
        if (vehicleRoles == null) {
            vehicleRoles = new AtinVehicleRoles();
            BeanUtil.quickCopy((Object)orderRoles, (Object)vehicleRoles);
            vehicleRoles.setUserId(userId);
            vehicleRoles.setLicenseNo(licenseNo);
            this.vehicleRolesMapper.insertSelective((Object)vehicleRoles);
        } else {
            Integer vehicleRolesId = vehicleRoles.getId();
            BeanUtil.quickCopy((Object)orderRoles, (Object)vehicleRoles);
            vehicleRoles.setId(vehicleRolesId);
            this.vehicleRolesMapper.updateByPrimaryKeySelective((Object)vehicleRoles);
        }
    }

    @Override
    public QuotationDto getQuotationResultByQuotationId(Integer quotationId) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount());
        rackBackPremium = rackBackPremium.setScale(2, 4);
        quotation.setRackbackPremium(rackBackPremium);
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        AtinRakebackRateConfig atinRakebackRateConfig = this.atinRakebackRateConfigMapper.selectRateConfigByIsAccess(Integer.valueOf(1));
        quotationDto.setRate(atinRakebackRateConfig.getVciRate());
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationResultByQuotationId(Integer quotationId, Integer parentId) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount());
        rackBackPremium = rackBackPremium.setScale(2, 4);
        quotation.setRackbackPremium(rackBackPremium);
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        AtinRakebackRateConfig atinRakebackRateConfig = this.atinRakebackRateConfigMapper.selectRateConfigByIsAccess(Integer.valueOf(1));
        quotationDto.setRate(atinRakebackRateConfig.getVciRate());
        AtinUser parentUser = (AtinUser)this.userMapper.selectByPrimaryKey(parentId);
        if (parentUser.getInvitCode().indexOf("ZHLH") > -1) {
            quotationDto.setIsSeedUser(AtinUser.IS_SEED_USER_YES);
        } else {
            quotationDto.setIsSeedUser(AtinUser.IS_SEED_USER_NO);
        }
        return quotationDto;
    }

    @Override
    public QuotationDto getQuotationResultByIdAndDiscount(Integer quotationId, BigDecimal agentDiscount) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        if (!agentDiscount.equals(0)) {
            agentDiscount = agentDiscount.divide(new BigDecimal(100));
            quotation.setAgentDiscount(agentDiscount);
            BigDecimal agentPremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agentDiscount));
            agentPremium = agentPremium.add(quotation.getTciPremium()).add(quotation.getSumTravelTax());
            quotation.setAgentPremium(agentPremium);
            BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount().subtract(agentDiscount));
            rackBackPremium = rackBackPremium.setScale(2, 4);
            quotation.setRackbackPremium(rackBackPremium);
        }
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        return quotationDto;
    }

    @Override
    public QuotationDto saveQuotationResultByIdAndDiscount(Integer quotationId, BigDecimal agentDiscount) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        if (!agentDiscount.equals(0)) {
            agentDiscount = agentDiscount.divide(new BigDecimal(100));
            quotation.setAgentDiscount(agentDiscount);
            BigDecimal agentPremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agentDiscount));
            agentPremium = agentPremium.add(quotation.getTciPremium()).add(quotation.getSumTravelTax());
            quotation.setAgentPremium(agentPremium);
            BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount().subtract(agentDiscount));
            rackBackPremium = rackBackPremium.setScale(2, 4);
            quotation.setRackbackPremium(rackBackPremium);
            this.update(quotation);
        }
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        return quotationDto;
    }

    @Override
    public QuotationDto saveQuotationResultByIdAndTciAndVciDiscount(Integer quotationId, BigDecimal agentDiscount, BigDecimal tciAgentDiscount) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        if (!agentDiscount.equals(0) || !tciAgentDiscount.equals(0)) {
            agentDiscount = agentDiscount.divide(new BigDecimal(100));
            quotation.setAgentDiscount(agentDiscount);
            tciAgentDiscount = tciAgentDiscount.divide(new BigDecimal(100));
            quotation.setTciAgentDiscount(tciAgentDiscount);
            BigDecimal agentPremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agentDiscount));
            agentPremium = agentPremium.add(quotation.getTciPremium().multiply(new BigDecimal(1).subtract(tciAgentDiscount)));
            agentDiscount = agentPremium.add(quotation.getSumTravelTax());
            quotation.setAgentPremium(agentPremium);
            BigDecimal rackBackPremium = quotation.getVciPremium().multiply(quotation.getAgencyDiscount().subtract(agentDiscount));
            rackBackPremium = rackBackPremium.add(quotation.getTciPremium().multiply(quotation.getTciAgencyDiscount().subtract(tciAgentDiscount)));
            rackBackPremium = rackBackPremium.setScale(2, 4);
            quotation.setRackbackPremium(rackBackPremium);
            this.update(quotation);
        }
        List quotationCoverageList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        QuotationDto quotationDto = this.quotationToDto(quotation, quotationCoverageList);
        Collections.sort(quotationDto.getCoverageList());
        return quotationDto;
    }

    @Override
    public int saveQuotationDto(Integer quotationId, BigDecimal agentPremium, BigDecimal agentDiscount, BigDecimal rackbackPremium) {
        AtinQuotation quotation = (AtinQuotation)this.quotationMapper.selectByPrimaryKey(quotationId);
        quotation.setRackbackPremium(rackbackPremium);
        quotation.setAgentPremium(agentPremium);
        quotation.setAgentDiscount(agentDiscount);
        return this.update(quotation);
    }

    private AtinOrderRoles changeOrderRoles(AtinOrderRoles orderRoles, AtinUser user) {
        orderRoles.setApplicantCertType("01");
        orderRoles.setInsuredCertNo(orderRoles.getApplicantCertNo());
        orderRoles.setInsuredCertType("01");
        orderRoles.setInsuredMobile(orderRoles.getApplicantMobile());
        orderRoles.setInsuredName(orderRoles.getApplicantName());
        orderRoles.setOwnerCertType("01");
        orderRoles.setOpenid(user.getOpenid());
        orderRoles.setNickname(user.getNickname());
        return orderRoles;
    }

    private QuotePriceReqDto setOrderRolesToQuotePriceReqDto(QuotePriceReqDto quotePriceReqDto, AtinOrderRoles orderRoles) {
        CustomerDataDto ownerData = new CustomerDataDto();
        ownerData.setCertNo(orderRoles.getOwnerCertNo());
        ownerData.setName(orderRoles.getOwnerName());
        ownerData.setPersonType("0");
        CustomerDataDto insurantData = new CustomerDataDto();
        insurantData.setName(orderRoles.getInsuredName());
        insurantData.setCertNo(orderRoles.getInsuredCertNo());
        insurantData.setMobile(orderRoles.getInsuredMobile());
        insurantData.setEmail(orderRoles.getInsuredEmail());
        insurantData.setPersonType("1");
        CustomerDataDto policyHolderData = new CustomerDataDto();
        policyHolderData.setMobile(orderRoles.getApplicantMobile());
        policyHolderData.setCertNo(orderRoles.getApplicantCertNo());
        policyHolderData.setName(orderRoles.getApplicantName());
        policyHolderData.setEmail(orderRoles.getApplicantEmail());
        policyHolderData.setPersonType("2");
        quotePriceReqDto.setOwnerData(ownerData);
        quotePriceReqDto.setInsurantData(insurantData);
        quotePriceReqDto.setPolicyHolderData(policyHolderData);
        return quotePriceReqDto;
    }

    private AtinOrder saveLbOrder(AtinPolicy policy, AtinUser user, AtinOrderRoles orderRoles, Integer agencyId) {
        AtinOrder lbOrder = new AtinOrder();
        lbOrder.setOrderSn(ServiceUtil.randomOrderSn());
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_SUBMIT);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_UNPAID);
        lbOrder.setShippingStatus(AtinOrder.SHIP_STATUS_UN_SEND);
        lbOrder.setAgencyDiscount(policy.getAgencyDiscount());
        lbOrder.setAgencyPremium(policy.getAgencyPremium());
        lbOrder.setMarketPremium(policy.getMarketPremium());
        lbOrder.setAgentPremium(policy.getAgentPremium());
        lbOrder.setAgentDiscount(policy.getAgentDiscount());
        lbOrder.setSumAmount(policy.getAgencyPremium());
        lbOrder.setRackbackPremium(policy.getRackbackPremium());
        lbOrder.setNetFeePremium(policy.getNetFeePremium());
        lbOrder.setPolicyId(policy.getId());
        lbOrder.setOrderRolesId(orderRoles.getId());
        lbOrder.setUserId(user.getId());
        lbOrder.setAgencyId(agencyId);
        this.lbOrderMapper.insertSelective((Object)lbOrder);
        lbOrder = this.lbOrderMapper.getOrderByPolicyId(policy.getId());
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setActionUser("\u7528\u6237");
        orderAction.setActionContent("\u7528\u6237\u4e0b\u5355");
        this.orderActionMapper.insertSelective((Object)orderAction);
        AtinPayLog payLog = new AtinPayLog();
        payLog.setOrderId(lbOrder.getId());
        payLog.setSumAmount(lbOrder.getSumAmount());
        payLog.setIsPaid(Integer.valueOf(0));
        this.payLogMapper.insertSelective((Object)payLog);
        return lbOrder;
    }

    private AtinPolicy saveQuotePriceByResDtoToPolicy(AtinQuotation quotePriceResDto, Integer quotationId) {
        AtinPolicy policy = new AtinPolicy();
        policy.setQuotationId(quotationId);
        policy.setChannel(ChannelConstants.CHANNEL);
        BeanUtil.quickCopy((Object)quotePriceResDto, (Object)policy);
        policy.setSumTravelTax(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getSumTravelTax())));
        policy.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getBenchmarkPremium())));
        policy.setAgencyPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getAgencyPremium())));
        policy.setTciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getTciPremium())));
        policy.setVciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getVciPremium())));
        policy.setQueryNo(quotePriceResDto.getQueryNo());
        policy.setInsuStartDate(new Date());
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        policy.setCityCode(quotation.getCityCode());
        policy.setAgencyId(quotation.getAgencyId());
        policy.setAgencyDiscount(quotation.getAgencyDiscount());
        policy.setTciAgencyDiscount(quotation.getTciAgencyDiscount());
        policy.setTciAgentDiscount(quotation.getTciAgentDiscount());
        policy.setAgentDiscount(quotation.getAgentDiscount());
        policy.setAgencyPremium(quotation.getAgencyPremium());
        policy.setAgentPremium(quotation.getAgentPremium());
        policy.setRackbackPremium(quotation.getRackbackPremium());
        policy.setTciStartDate(quotation.getTciStartDate());
        policy.setVciStartDate(quotation.getVciStartDate());
        policy.setNetFeePremium(quotation.getNetFeePremium());
        this.policyMapper.insertSelective((Object)policy);
        ArrayList<AtinPolicyCoverage> policyCoverageList = new ArrayList<AtinPolicyCoverage>();
        List coverageDataDtoList = this.quotationCoverageMapper.getQuoteCoverageListByQuoteId(quotationId);
        for (AtinQuotationCoverage coverageDataDto : coverageDataDtoList) {
            AtinPolicyCoverage policyCoverage = new AtinPolicyCoverage();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)policyCoverage);
            policyCoverage.setReason(CommonUtil.isEmpty((String)coverageDataDto.getReason()) ? "" : coverageDataDto.getReason());
            policyCoverage.setQuantity(NumberUtil.nullToZero((Integer)coverageDataDto.getQuantity()));
            policyCoverage.setAmount(coverageDataDto.getAmount());
            policyCoverage.setUnimount(coverageDataDto.getUnimount());
            policyCoverage.setModelCode(coverageDataDto.getModelCode());
            policyCoverage.setPremium(coverageDataDto.getPremium());
            policyCoverage.setBenchmarkPremium(coverageDataDto.getBenchmarkPremium());
            policyCoverage.setDiscount(new BigDecimal(0));
            policyCoverage.setPolicyId(policy.getId());
            policyCoverageList.add(policyCoverage);
        }
        this.policyCoverageMapper.batchInsert(policyCoverageList);
        return policy;
    }

    private AtinPolicy saveQuotePriceResDtoToPolicy(QuotePriceResDto quotePriceResDto, Integer quotationId) {
        AtinPolicy policy = new AtinPolicy();
        policy.setQuotationId(quotationId);
        policy.setChannel(ChannelConstants.CHANNEL);
        BeanUtil.quickCopy((Object)quotePriceResDto, (Object)policy);
        policy.setSumTravelTax(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getSumTravelTax())));
        policy.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getBenchmarkPremium())));
        policy.setAgencyPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getPremium())));
        policy.setTciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getTciPremium())));
        policy.setVciPremium(ServiceUtil.getBigDecimal(String.valueOf(quotePriceResDto.getVciPremium())));
        policy.setQueryNo(quotePriceResDto.getQuoteNo());
        policy.setInsuStartDate(new Date());
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        policy.setCityCode(quotation.getCityCode());
        policy.setAgencyId(quotation.getAgencyId());
        policy.setAgencyDiscount(quotation.getAgencyDiscount());
        policy.setAgentDiscount(quotation.getAgentDiscount());
        policy.setAgencyPremium(quotation.getAgencyPremium());
        policy.setAgentPremium(quotation.getAgentPremium());
        policy.setRackbackPremium(quotation.getRackbackPremium());
        policy.setTciStartDate(quotation.getTciStartDate());
        policy.setVciStartDate(quotation.getVciStartDate());
        policy.setNetFeePremium(quotation.getNetFeePremium());
        this.policyMapper.insertSelective((Object)policy);
        ArrayList<AtinPolicyCoverage> policyCoverageList = new ArrayList<AtinPolicyCoverage>();
        for (CoverageDataDto coverageDataDto : quotePriceResDto.getCoverageList()) {
            AtinPolicyCoverage policyCoverage = new AtinPolicyCoverage();
            BeanUtil.quickCopy((Object)coverageDataDto, (Object)policyCoverage);
            policyCoverage.setReason(CommonUtil.isEmpty((String)coverageDataDto.getReason()) ? "" : coverageDataDto.getReason());
            policyCoverage.setQuantity(NumberUtil.nullToZero((Integer)coverageDataDto.getQuantity()));
            policyCoverage.setAmount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getAmount()))));
            policyCoverage.setUnimount(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getUnitAmount()))));
            policyCoverage.setModelCode(Integer.valueOf(CommonUtil.isNotEmpty((String)coverageDataDto.getModeCode()) ? new Integer(coverageDataDto.getModeCode()) : 0));
            policyCoverage.setPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getPremium()))));
            policyCoverage.setBenchmarkPremium(ServiceUtil.getBigDecimal(String.valueOf(NumberUtil.nullToZero((Integer)coverageDataDto.getBenchmarkPremium()))));
            policyCoverage.setDiscount(new BigDecimal(0));
            policyCoverage.setPolicyId(policy.getId());
            policyCoverageList.add(policyCoverage);
        }
        this.policyCoverageMapper.batchInsert(policyCoverageList);
        return policy;
    }

    @Override
    public int saveOrderRolesByQuotePriceReqDto(Integer agentId, AtinUser user, Integer agencyId, Integer quotationId, String phone) {
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        AtinPolicy policyExist = this.policyMapper.getPolicyByQuotationId(String.valueOf(quotationId));
        if (null != policyExist) {
            AtinOrder lbOrder = this.lbOrderMapper.getOrderByPolicyId(policyExist.getId());
            return lbOrder.getId();
        }
        AtinVehicleRoles vehicleRoles = this.vehicleRolesMapper.selectOneByQuotationId(quotationId);
        AtinOrderRoles orderRoles = new AtinOrderRoles();
        orderRoles.setApplicantName(vehicleRoles.getApplicantName());
        orderRoles.setApplicantMobile(vehicleRoles.getApplicantMobile());
        orderRoles.setApplicantCertNo(vehicleRoles.getApplicantCertNo());
        orderRoles.setApplicantEmail(vehicleRoles.getApplicantEmail());
        orderRoles.setInsuredName(vehicleRoles.getInsuredName());
        if (CommonUtil.isNotEmpty((String)phone)) {
            orderRoles.setInsuredMobile(phone);
        }
        orderRoles.setInsuredMobile(vehicleRoles.getInsuredMobile());
        orderRoles.setInsuredCertNo(vehicleRoles.getInsuredCertNo());
        orderRoles.setInsuredEmail(vehicleRoles.getInsuredEmail());
        orderRoles.setOwnerName(vehicleRoles.getOwnerName());
        orderRoles.setOwnerCertNo(vehicleRoles.getOwnerCertNo());
        AtinUser agencyUser = (AtinUser)this.userMapper.selectByPrimaryKey(agentId);
        if (CommonUtil.isNotEmpty((String)agencyUser.getOpenid())) {
            orderRoles.setOpenid(agencyUser.getOpenid());
        } else {
            orderRoles.setOpenid(String.valueOf(agentId));
        }
        this.orderRolesMapper.insertSelective((Object)orderRoles);
        orderRoles = CommonUtil.isNotEmpty((String)agencyUser.getOpenid()) ? this.orderRolesMapper.selectUserOrderByOpenId(agencyUser.getOpenid()) : this.orderRolesMapper.selectUserOrderByOpenId(String.valueOf(agentId));
        AtinPolicy policy = this.saveQuotePriceByResDtoToPolicy(quotation, quotationId);
        AtinOrder lbOrder = this.saveLbOrder(policy, agencyUser, orderRoles, agencyId);
        return lbOrder.getId();
    }

    private Date formatToDate(String dstr) {
        return DateUtil.parseDate((String)dstr, (String)"yyyy-MM-dd");
    }

    @Override
    public BigDecimal reQuoteNetFee(AtinUser user, Integer agentId, Integer quotationId) {
        BigDecimal agencyDiscount;
        AtinQuotation quotation = (AtinQuotation)this.getByID(quotationId);
        AtinUser userAgent = (AtinUser)this.userMapper.selectByPrimaryKey(agentId);
        AtinAgencySupportInsuc agencySupportInsuc = ServiceUtil.getAgencySupportInsuc(quotation.getInsuCom(), quotation.getLicenseNo(), quotation.getAgencyId());
        Integer id = agencySupportInsuc.getId();
        AtinAgentRate agentRate = this.agentRateMapper.getAgenyDiscount(userAgent.getId(), id);
        String cityCode = ServiceUtil.getCityCodeByLicenseNo(quotation.getLicenseNo());
        if (agentRate == null) {
            AtinAgencySupportInsuc supportInsuc = this.agencySupportInsucMapper.getAgencyInsurerCityRate(quotation.getAgencyId(), quotation.getInsuCom(), cityCode);
            agencyDiscount = supportInsuc.getDiscount();
        } else {
            agencyDiscount = agentRate.getDiscount();
        }
        quotation.setAgencyDiscount(agencyDiscount);
        BigDecimal netFeePremium = quotation.getVciPremium().multiply(new BigDecimal(1).subtract(agencyDiscount));
        netFeePremium = netFeePremium.add(quotation.getTciPremium()).add(quotation.getSumTravelTax());
        quotation.setNetFeePremium(netFeePremium);
        quotation.setAgentId(agentId);
        int result = this.update(quotation);
        if (result == 1) {
            return quotation.getNetFeePremium();
        }
        return null;
    }

    private void cancelOrder(String insuCom, String licenseNo) {
        AtinOrder order;
        AtinPolicy policy = this.policyMapper.findNewByLicenseNo(insuCom, licenseNo);
        if (policy != null && (order = this.lbOrderMapper.findOrderByPolicyId(policy.getId())) != null) {
            if (AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS.intValue() == order.getOrderStatus().intValue()) {
                order.setOrderStatus(AtinOrder.ORDER_STATUS_CANCEL);
                this.lbOrderMapper.updateByPrimaryKey((Object)order);
                AtinOrderAction action = new AtinOrderAction();
                action.setOrderStatus(AtinOrder.ORDER_STATUS_CANCEL);
                action.setActionContent("\u91cd\u65b0\u62a5\u4ef7\u53d6\u6d88\u6700\u65b0\u7684\u6838\u4fdd\u6210\u529f\u8ba2\u5355");
                action.setActionNote("\u91cd\u65b0\u62a5\u4ef7\u53d6\u6d88\u6700\u65b0\u7684\u6838\u4fdd\u6210\u529f\u8ba2\u5355");
                action.setActionUser("program");
                action.setCreateTime(new Date());
                action.setOrderId(order.getId());
                action.setOrderSn(order.getOrderSn());
                action.setPayStatus(AtinOrder.PAY_STATUS_UNPAID);
                action.setShippingStatus(AtinOrder.SHIP_STATUS_UN_SEND);
                this.orderActionMapper.insert((Object)action);
            } else {
                if (AtinOrder.ORDER_STATUS_USER_PAID.intValue() == order.getOrderStatus().intValue()) {
                    throw new CommonException(1, "\u7528\u6237\u5df2\u652f\u4ed8,\u5df2\u652f\u4ed8\u7684\u8f66\u8f86\u4e0d\u652f\u6301\u91cd\u65b0\u62a5\u4ef7!");
                }
                if (AtinOrder.ORDER_STATUS_LUOBO_PAID.intValue() == order.getOrderStatus().intValue()) {
                    throw new CommonException(1, "\u5e73\u53f0\u5df2\u652f\u4ed8,\u5df2\u652f\u4ed8\u7684\u8f66\u8f86\u4e0d\u652f\u6301\u91cd\u65b0\u62a5\u4ef7!");
                }
            }
        }
    }
}

