/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.impl;

import com.alibaba.fastjson.JSON;
import com.zhlh.Tiny.exception.CommonException;
import com.zhlh.Tiny.page.bean.Page;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.karma.domain.model.AtinAllowanceRecord;
import com.zhlh.karma.domain.model.AtinCoverage;
import com.zhlh.karma.domain.model.AtinInsurer;
import com.zhlh.karma.domain.model.AtinOrder;
import com.zhlh.karma.domain.model.AtinOrderAction;
import com.zhlh.karma.domain.model.AtinOrderRoles;
import com.zhlh.karma.domain.model.AtinPayLog;
import com.zhlh.karma.domain.model.AtinPolicy;
import com.zhlh.karma.domain.model.AtinPolicyCoverage;
import com.zhlh.karma.domain.model.AtinQuotation;
import com.zhlh.karma.domain.model.AtinRakebackInfo;
import com.zhlh.karma.domain.model.AtinRakebackRateConfig;
import com.zhlh.karma.domain.model.AtinRakebackRecord;
import com.zhlh.karma.domain.model.AtinUser;
import com.zhlh.karma.dto.CbsNotifyDto;
import com.zhlh.karma.dto.OrderDto;
import com.zhlh.karma.dto.OrderInfoDto;
import com.zhlh.karma.dto.PolicyCoverageDto;
import com.zhlh.karma.dto.PolicyDto;
import com.zhlh.karma.dto.RmNotifyDto;
import com.zhlh.karma.mapper.AtinAllowanceRecordMapper;
import com.zhlh.karma.mapper.AtinOrderActionMapper;
import com.zhlh.karma.mapper.AtinOrderMapper;
import com.zhlh.karma.mapper.AtinOrderRolesMapper;
import com.zhlh.karma.mapper.AtinPayLogMapper;
import com.zhlh.karma.mapper.AtinPolicyCoverageMapper;
import com.zhlh.karma.mapper.AtinPolicyMapper;
import com.zhlh.karma.mapper.AtinQuotationMapper;
import com.zhlh.karma.mapper.AtinRakebackInfoMapper;
import com.zhlh.karma.mapper.AtinRakebackRateConfigMapper;
import com.zhlh.karma.mapper.AtinRakebackRecordMapper;
import com.zhlh.karma.mapper.AtinUserAgencyMapper;
import com.zhlh.karma.mapper.AtinUserMapper;
import com.zhlh.karma.mapper.BaseMapper;
import com.zhlh.karma.service.OrderService;
import com.zhlh.karma.service.common.ServiceUtil;
import com.zhlh.karma.service.constant.ChannelConstants;
import com.zhlh.karma.service.impl.BaseServiceImpl;
import com.zhlh.karma.service.wechat.MessageHelper;
import com.zhlh.zeus.api.IdentityCollectRService;
import com.zhlh.zeus.api.InsureConfirmRService;
import com.zhlh.zeus.api.LuobarPayRService;
import com.zhlh.zeus.api.NotifyPayResultRService;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectReqDto;
import com.zhlh.zeus.dto.identityCollect.IdentityCollectResDto;
import com.zhlh.zeus.dto.insureConfirm.InsureConfirmReqDto;
import com.zhlh.zeus.dto.insureConfirm.InsureConfirmResDto;
import com.zhlh.zeus.dto.pay.LuoberPayReqDto;
import com.zhlh.zeus.dto.pay.LuoberPayResDto;
import com.zhlh.zeus.dto.pay.NotifyPayResultReqDto;
import com.zhlh.zeus.dto.pay.NotifyPayResultResDto;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends BaseServiceImpl<AtinOrder>
implements OrderService {
    @Autowired
    private AtinOrderMapper orderMapper;
    @Autowired
    private AtinPolicyMapper policyMapper;
    @Autowired
    private AtinPolicyCoverageMapper policyCoverageMapper;
    @Autowired
    private AtinOrderRolesMapper orderRolesMapper;
    @Autowired
    private IdentityCollectRService identityCollectRService;
    @Autowired
    private InsureConfirmRService insureConfirmRService;
    @Autowired
    private LuobarPayRService luobarPayRService;
    @Autowired
    private AtinOrderActionMapper orderActionMapper;
    @Autowired
    private AtinPayLogMapper payLogMapper;
    @Autowired
    private AtinUserMapper userMapper;
    @Autowired
    private NotifyPayResultRService notifyPayResultRService;
    @Autowired
    private AtinUserAgencyMapper userAgencyMapper;
    @Autowired
    private AtinQuotationMapper quotationMapper;
    @Autowired
    private AtinRakebackRateConfigMapper atinRakebackRateConfigMapper;
    @Autowired
    private AtinRakebackRecordMapper atinRakebackRecordMapper;
    @Autowired
    private AtinRakebackInfoMapper atinRakebackInfoMapper;
    @Autowired
    private AtinAllowanceRecordMapper atinAllowanceRecordMapper;

    @Override
    public BaseMapper<AtinOrder> getBaseMapper() {
        return this.orderMapper;
    }

    private List<OrderDto> findOrderDtoListByOrderList(List<AtinOrder> orderList) {
        ArrayList<OrderDto> orderDtoList = new ArrayList<OrderDto>();
        ArrayList<Integer> policyIdList = new ArrayList<Integer>();
        ArrayList<Integer> orderRolesIdList = new ArrayList<Integer>();
        if (null == orderList) {
            return orderDtoList;
        }
        for (int i = 0; i < orderList.size(); ++i) {
            Integer orderRolesId;
            AtinOrder order = orderList.get(i);
            OrderDto orderDto = new OrderDto();
            BeanUtil.quickCopy((Object)order, (Object)((Object)orderDto));
            orderDtoList.add(orderDto);
            Integer policyId = order.getPolicyId();
            if (null != policyId) {
                policyIdList.add(policyId);
            }
            if (null == (orderRolesId = order.getOrderRolesId())) continue;
            orderRolesIdList.add(orderRolesId);
        }
        List orderRolesList = new ArrayList();
        if (orderRolesIdList.size() > 0) {
            orderRolesList = this.orderRolesMapper.getOrderRolesListByIdList(orderRolesIdList);
        }
        List policyList = new ArrayList();
        if (policyIdList.size() > 0) {
            policyList = this.policyMapper.getPolicyListByIdList(policyIdList);
        }
        List policyCountList = new ArrayList();
        if (policyIdList.size() > 0) {
            policyCountList = this.policyCoverageMapper.getCountList(policyIdList);
        }
        HashMap<Integer, String> orderRolesMap = new HashMap<Integer, String>();
        for (AtinOrderRoles orderRoles : orderRolesList) {
            orderRolesMap.put(orderRoles.getId(), orderRoles.getInsuredName());
        }
        HashMap<Integer, AtinPolicy> policyMap = new HashMap<Integer, AtinPolicy>();
        for (AtinPolicy policy : policyList) {
            policyMap.put(policy.getId(), policy);
        }
        HashMap<Integer, Long> policyCoverageMap = new HashMap<Integer, Long>();
        for (Map map : policyCountList) {
            Integer policyMapId = (Integer)map.get("policyId");
            Long count = (Long)map.get("count");
            policyCoverageMap.put(policyMapId, count);
        }
        for (OrderDto orderDto : orderDtoList) {
            AtinInsurer insurer;
            Long count;
            String insuredName;
            Object policyObject = policyMap.get(orderDto.getPolicyId());
            if (null == policyObject) continue;
            AtinPolicy policy = (AtinPolicy)policyObject;
            orderDto.setLicenseNo(policy.getLicenseNo());
            orderDto.setInsuCom(policy.getInsuCom());
            Date date = orderDto.getCreateTime();
            if (null != date) {
                String createTime = DateFormat.getDateInstance(2).format(date);
                orderDto.setCreateOrderTime(createTime);
            }
            Integer policyId = policy.getId();
            Integer rolesId = orderDto.getOrderRolesId();
            Object insuredNameObject = orderRolesMap.get(rolesId);
            if (null != insuredNameObject && CommonUtil.isNotEmpty((String)(insuredName = (String)insuredNameObject))) {
                orderDto.setInsuredName(insuredName);
            }
            if (null != policyCoverageMap.get(policyId) && null != (count = (Long)policyCoverageMap.get(policyId))) {
                orderDto.setCoverageCount(count.intValue());
            }
            if (null == (insurer = ServiceUtil.getInsurerByCode(policy.getInsuCom()))) continue;
            orderDto.setInsuComName(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getAbbreviation());
            orderDto.setInsurerImgUrl(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getImgUrl());
        }
        return orderDtoList;
    }

    @Override
    public List<OrderDto> findOrderDtoListByPayStatus(Integer userId, Integer payStatus) {
        List orderList = this.orderMapper.findOrderListByStatus(userId, payStatus);
        return this.findOrderDtoListByOrderList(orderList);
    }

    @Override
    public int cancelOrder(Integer id) {
        AtinOrder orderInfoDto = (AtinOrder)this.getByID(id);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)orderInfoDto, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7528\u6237");
        orderAction.setActionContent("\u7528\u6237\u53d6\u6d88\u8ba2\u5355");
        this.orderActionMapper.insertSelective((Object)orderAction);
        return this.orderMapper.changeOrderStatus(AtinOrder.ORDER_STATUS_CANCEL, id);
    }

    @Override
    public Integer findCountByPayStatus(Integer userId, Integer payStatus) {
        return this.orderMapper.getCountByStatus(userId, payStatus);
    }

    @Override
    public OrderInfoDto getOrderInfoDtoByOrderId(Integer orderId) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrder(orderId);
        return orderInfoDto;
    }

    public OrderInfoDto getOrderInfoDtoByOrder(Integer orderId) {
        OrderInfoDto orderInfoDto = new OrderInfoDto();
        AtinOrder lbOrder = (AtinOrder)this.orderMapper.selectByPrimaryKey(orderId);
        if (null == lbOrder) {
            return orderInfoDto;
        }
        BeanUtil.quickCopy((Object)lbOrder, (Object)((Object)orderInfoDto));
        orderInfoDto.setSumAmount(lbOrder.getSumAmount());
        orderInfoDto.setExpireTime(this.calcExpireTime(lbOrder));
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(lbOrder.getPolicyId());
        PolicyDto policyDto = new PolicyDto();
        BeanUtil.quickCopy((Object)policy, (Object)((Object)policyDto));
        policyDto.setInsuComName(ServiceUtil.getInsurerByCode(policy.getInsuCom()).getAbbreviation());
        ArrayList<PolicyCoverageDto> policyCoverageDtoList = new ArrayList<PolicyCoverageDto>();
        List policyCoverageList = this.policyCoverageMapper.getCoverageList(policy.getId());
        for (AtinPolicyCoverage policyCoverage : policyCoverageList) {
            PolicyCoverageDto policyCoverageDto = new PolicyCoverageDto();
            BeanUtil.quickCopy((Object)policyCoverage, (Object)policyCoverageDto);
            AtinCoverage coverage = ServiceUtil.getCoverageByCode(policyCoverage.getCoverageCode());
            policyCoverageDto.setName(coverage.getName());
            policyCoverageDto.setAssortment(coverage.getAssortment());
            policyCoverageDtoList.add(policyCoverageDto);
        }
        policyDto.setCoverageList(policyCoverageDtoList);
        orderInfoDto.setPolicyDto(policyDto);
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(lbOrder.getOrderRolesId());
        orderInfoDto.setOrderRoles(orderRoles);
        Collections.sort(policyDto.getCoverageList());
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(policy.getAgentId());
        orderInfoDto.setUser(user);
        Integer quotationId = policy.getQuotationId();
        AtinQuotation quotation = null;
        if (quotationId != null && quotationId != 0) {
            quotation = (AtinQuotation)this.quotationMapper.selectByPrimaryKey(quotationId);
        }
        String isElcInvoice = "";
        if (quotation != null) {
            isElcInvoice = quotation.getIsElcInvoice();
        }
        orderInfoDto.setIsElcInvoice(isElcInvoice);
        AtinRakebackRateConfig atinRakebackRateConfig = this.atinRakebackRateConfigMapper.selectRateConfigByIsAccess(Integer.valueOf(1));
        orderInfoDto.setRate(atinRakebackRateConfig.getVciRate());
        return orderInfoDto;
    }

    @Override
    public OrderInfoDto getOrderInfoDtoByOrderId(Integer orderId, Integer parentId) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrder(orderId);
        AtinUser parentUser = (AtinUser)this.userMapper.selectByPrimaryKey(parentId);
        if (parentUser.getInvitCode().indexOf("ZHLH") > -1) {
            orderInfoDto.setIsSeedUser(AtinUser.IS_SEED_USER_YES);
        } else {
            orderInfoDto.setIsSeedUser(AtinUser.IS_SEED_USER_NO);
        }
        return orderInfoDto;
    }

    @Override
    public String insureConfirm(Integer orderId, String code) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        if (orderInfoDto.getOrderStatus() != null && orderInfoDto.getOrderStatus() == AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS) {
            return "";
        }
        InsureConfirmReqDto insureConfirmReqDto = this.getInsureConfirmReqDtoByOrderInfo(orderInfoDto);
        insureConfirmReqDto.setVerificationCode(code);
        insureConfirmReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(orderInfoDto.getPolicyDto().getLicenseNo()));
        insureConfirmReqDto.setInsuCom(orderInfoDto.getPolicyDto().getInsuCom());
        insureConfirmReqDto.setPartner("zhlh");
        insureConfirmReqDto.setChannel(ChannelConstants.CHANNEL);
        insureConfirmReqDto.setOrigin(ChannelConstants.CHANNEL);
        InsureConfirmResDto insureConfirmResDto = this.insureConfirmRService.insureConfirm(insureConfirmReqDto);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)((Object)orderInfoDto), (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7cfb\u7edf");
        if (insureConfirmResDto.getErrCode() != 0) {
            orderAction.setActionContent("\u6838\u4fdd\u5931\u8d25");
            orderAction.setActionNote(insureConfirmResDto.getErrMsg());
            this.orderActionMapper.insertSelective((Object)orderAction);
            throw new CommonException(insureConfirmResDto.getErrCode().intValue(), insureConfirmResDto.getErrMsg());
        }
        orderAction.setActionContent("\u6838\u4fdd\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
        AtinPolicy policy = new AtinPolicy();
        policy.setId(orderInfoDto.getPolicyDto().getId());
        policy.setModifyTime(new Date());
        BeanUtil.quickCopy((Object)insureConfirmResDto, (Object)policy);
        this.policyMapper.updateByPrimaryKeySelective((Object)policy);
        this.orderMapper.changeOrderStatus(AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS, orderId);
        AtinRakebackRecord atinRakebackRecord = new AtinRakebackRecord();
        atinRakebackRecord.setUserId(orderInfoDto.getUserId());
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(orderInfoDto.getUserId());
        atinRakebackRecord.setParentId(user.getParentId());
        atinRakebackRecord.setOrderId(orderInfoDto.getId());
        atinRakebackRecord.setPremium(orderInfoDto.getAgencyPremium());
        atinRakebackRecord.setVciScale(orderInfoDto.getAgentDiscount());
        PolicyDto policyDto = orderInfoDto.getPolicyDto();
        atinRakebackRecord.setTciScale(policyDto.getTciAgentDiscount());
        atinRakebackRecord.setAgencyRate(orderInfoDto.getAgencyDiscount());
        BigDecimal rekebackAmount = orderInfoDto.getAgencyPremium().subtract(orderInfoDto.getNetFeePremium());
        atinRakebackRecord.setReckbackAward(rekebackAmount);
        AtinRakebackRateConfig atinRakebackRateConfig = this.atinRakebackRateConfigMapper.selectRateConfigByIsAccess(Integer.valueOf(1));
        BigDecimal parentRakeBackAmount = policyDto.getVciPremium().multiply(atinRakebackRateConfig.getVciRate());
        parentRakeBackAmount = parentRakeBackAmount.add(policyDto.getTciPremium().multiply(atinRakebackRateConfig.getTciRate()));
        atinRakebackRecord.setParentRakebackAmount(parentRakeBackAmount);
        atinRakebackRecord.setParentRakebackVciRate(atinRakebackRateConfig.getVciRate());
        atinRakebackRecord.setParentRakebackTciRate(atinRakebackRateConfig.getTciRate());
        this.atinRakebackRecordMapper.insertSelective((Object)atinRakebackRecord);
        return policy.getInnerPlcyNo();
    }

    @Override
    public void identityCollect(Integer orderId, String phone) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        IdentityCollectReqDto identityCollectReqDto = this.getIdentityCollectReqDtoByOrderInfo(orderInfoDto);
        identityCollectReqDto.setMobile(phone);
        identityCollectReqDto.setOrigin(ChannelConstants.CHANNEL);
        identityCollectReqDto.setPartner("zhlh");
        IdentityCollectResDto identityCollectResDto = this.identityCollectRService.identityCollect(identityCollectReqDto);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(orderInfoDto.getId());
        BeanUtil.quickCopy((Object)((Object)orderInfoDto), (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(new Date());
        orderAction.setActionUser("\u7cfb\u7edf");
        if (identityCollectResDto.getErrCode() != 0) {
            orderAction.setActionContent("\u8eab\u4efd\u91c7\u96c6\u5931\u8d25");
            orderAction.setActionNote(identityCollectResDto.getErrMsg());
            this.orderActionMapper.insertSelective((Object)orderAction);
            throw new CommonException(identityCollectResDto.getErrCode().intValue(), identityCollectResDto.getErrMsg());
        }
        orderAction.setActionContent("\u8eab\u4efd\u91c7\u96c6\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
    }

    @Override
    public LuoberPayResDto orderPay(Integer orderId, String tradeType, String ip) {
        OrderInfoDto orderInfoDto = this.getOrderInfoDtoByOrderId(orderId);
        log.info("\u8ba2\u5355\u8be6\u60c5 orderInfoDto {}", (Object)JSON.toJSONString((Object)((Object)orderInfoDto)));
        if (orderInfoDto.getPayStatus() != null && AtinOrder.PAY_STATUS_PAID == orderInfoDto.getPayStatus()) {
            throw new CommonException("\u8be5\u8ba2\u5355\u5df2\u4ed8\u6b3e");
        }
        if (orderInfoDto.getOrderStatus() != null && AtinOrder.ORDER_STATUS_SUBMIT == orderInfoDto.getOrderStatus()) {
            throw new CommonException("\u6838\u4fdd\u672a\u901a\u8fc7\u6216\u672a\u6838\u4fdd,\u8bf7\u91cd\u65b0\u8be2\u4ef7");
        }
        LuoberPayReqDto luoberPayReqDto = this.getLuoberPayReqDtoByOrderInfo(orderInfoDto);
        luoberPayReqDto.setTradeType(tradeType);
        luoberPayReqDto.setPartner("zhlh");
        luoberPayReqDto.setOrigin(ChannelConstants.CHANNEL);
        luoberPayReqDto.setCityCode(orderInfoDto.getPolicyDto().getCityCode());
        String paramInfo = JSON.toJSONString((Object)luoberPayReqDto);
        log.info("\u652f\u4ed8\u8bf7\u6c42\u5bf9\u8c61 luoberPayReqDto {}", (Object)paramInfo);
        LuoberPayResDto luoberPayResDto = this.luobarPayRService.luoberPay(luoberPayReqDto);
        if (luoberPayResDto.getErrCode() != 0) {
            throw new CommonException(luoberPayResDto.getErrCode().intValue(), luoberPayResDto.getErrMsg());
        }
        return luoberPayResDto;
    }

    @Override
    public AtinOrder rmNotify(RmNotifyDto rmNotify) {
        Date now = new Date();
        AtinPolicy policy = this.policyMapper.getPolicyByInnerPlcyNo(rmNotify.getInnerPlcyNo());
        AtinOrder lbOrder = this.orderMapper.getOrderByPolicyId(policy.getId());
        if (lbOrder.getPayStatus().intValue() == AtinOrder.PAY_STATUS_PAID.intValue()) {
            return lbOrder;
        }
        AtinPayLog payLog = this.payLogMapper.getByOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)rmNotify, (Object)payLog);
        payLog.setIsPaid(Integer.valueOf(1));
        payLog.setPayTime(now);
        this.payLogMapper.updateByPrimaryKeySelective((Object)payLog);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_PAID);
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_USER_PAID);
        this.orderMapper.updateByPrimaryKeySelective((Object)lbOrder);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(now);
        orderAction.setActionUser("\u7cfb\u7edf");
        orderAction.setActionContent("\u4ed8\u6b3e\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(lbOrder.getUserId());
        String insurerName = ServiceUtil.getInsurerByCode(policy.getInsuCom()).getAbbreviation();
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(lbOrder.getOrderRolesId());
        MessageHelper.notifyPaySuccess(user.getOpenid(), user.getNickname(), insurerName, orderRoles.getApplicantName(), lbOrder.getAgencyPremium(), lbOrder.getId(), lbOrder.getOrderSn(), policy.getCityCode());
        return lbOrder;
    }

    @Override
    public void cbsNotify(CbsNotifyDto cbsNotify) {
        Date now = new Date();
        AtinPolicy policy = this.policyMapper.getPolicyByInnerPlcyNo(cbsNotify.getInnerPlcyNo());
        AtinOrder lbOrder = this.orderMapper.getOrderByPolicyId(policy.getId());
        if (lbOrder.getPayStatus().intValue() == AtinOrder.PAY_STATUS_PAY_INSURE.intValue()) {
            return;
        }
        BeanUtil.quickCopy((Object)cbsNotify, (Object)policy);
        policy.setModifyTime(now);
        this.policyMapper.updateByPrimaryKeySelective((Object)policy);
        lbOrder.setPayStatus(AtinOrder.PAY_STATUS_PAY_INSURE);
        lbOrder.setOrderStatus(AtinOrder.ORDER_STATUS_LUOBO_PAID);
        this.orderMapper.updateByPrimaryKeySelective((Object)lbOrder);
        Integer userId = lbOrder.getUserId();
        AtinUser user = (AtinUser)this.userMapper.selectByPrimaryKey(userId);
        AtinUser parentUser = (AtinUser)this.userMapper.selectByPrimaryKey(user.getParentId());
        AtinRakebackRecord atinRakebackRecord = this.atinRakebackRecordMapper.getRecordByOrderId(lbOrder.getId());
        AtinRakebackInfo atinRakebackInfo = this.atinRakebackInfoMapper.findByUserId(userId);
        if (atinRakebackInfo == null) {
            atinRakebackInfo = new AtinRakebackInfo();
            atinRakebackInfo.setUserId(userId);
            atinRakebackInfo.setOrderTotalNum(Integer.valueOf(1));
            atinRakebackInfo.setAwardAmount(atinRakebackRecord.getReckbackAward());
            atinRakebackInfo.setOrderTotalAmount(lbOrder.getSumAmount());
            if (parentUser.getInvitCode().indexOf("ZHLH") > -1) {
                this.sumUserBanlanceAmount(user, atinRakebackRecord);
            } else {
                this.sumRakeAndAllowanceAndUserBanlanceAmount(user, atinRakebackRecord, atinRakebackInfo, lbOrder);
            }
            this.atinRakebackInfoMapper.insertSelective((Object)atinRakebackInfo);
        } else {
            atinRakebackInfo.setOrderTotalNum(Integer.valueOf(atinRakebackInfo.getOrderTotalNum() + 1));
            atinRakebackInfo.setAwardAmount(atinRakebackInfo.getCurrentOrderAmount().add(atinRakebackRecord.getReckbackAward()));
            atinRakebackInfo.setOrderTotalAmount(atinRakebackInfo.getOrderTotalAmount().add(lbOrder.getSumAmount()));
            if (parentUser.getInvitCode().indexOf("ZHLH") > -1) {
                this.sumUserBanlanceAmount(user, atinRakebackRecord);
            } else {
                this.sumRakeAndAllowanceAndUserBanlanceAmount(user, atinRakebackRecord, atinRakebackInfo, lbOrder);
            }
            this.atinRakebackInfoMapper.updateByPrimaryKeySelective((Object)atinRakebackInfo);
        }
        this.userMapper.updateByPrimaryKeySelective((Object)user);
        AtinOrderAction orderAction = new AtinOrderAction();
        orderAction.setOrderId(lbOrder.getId());
        BeanUtil.quickCopy((Object)lbOrder, (Object)orderAction);
        orderAction.setId(null);
        orderAction.setCreateTime(now);
        orderAction.setActionUser("\u7cfb\u7edf");
        orderAction.setActionContent("\u5411\u4fdd\u9669\u516c\u53f8\u4ed8\u6b3e\u6210\u529f");
        this.orderActionMapper.insertSelective((Object)orderAction);
    }

    public void sumUserBanlanceAmount(AtinUser user, AtinRakebackRecord atinRakebackRecord) {
        BigDecimal useAmountBalance = user.getAmountBalance();
        useAmountBalance = useAmountBalance.add(atinRakebackRecord.getReckbackAward());
        user.setAmountBalance(useAmountBalance);
    }

    public void sumRakeAndAllowanceAndUserBanlanceAmount(AtinUser user, AtinRakebackRecord atinRakebackRecord, AtinRakebackInfo atinRakebackInfo, AtinOrder lbOrder) {
        AtinUser parentUser = (AtinUser)this.userMapper.selectByPrimaryKey(user.getParentId());
        BigDecimal useAmountBalance = user.getAmountBalance();
        useAmountBalance = useAmountBalance.add(atinRakebackRecord.getReckbackAward());
        user.setAmountBalance(useAmountBalance);
        BigDecimal parentAmountBalance = parentUser.getAmountBalance();
        parentAmountBalance = parentAmountBalance.add(atinRakebackRecord.getParentRakebackAmount());
        parentUser.setAmountBalance(parentAmountBalance);
        this.userMapper.updateByPrimaryKeySelective((Object)parentUser);
        BigDecimal awardAmount = atinRakebackInfo.getAwardAmount();
        awardAmount = awardAmount.add(atinRakebackRecord.getReckbackAward());
        atinRakebackInfo.setAwardAmount(awardAmount);
        atinRakebackInfo.setOrderTotalNum(Integer.valueOf(atinRakebackInfo.getOrderTotalNum() + 1));
        BigDecimal orderTotalAmount = atinRakebackInfo.getOrderTotalAmount();
        orderTotalAmount = orderTotalAmount.add(atinRakebackRecord.getPremium());
        atinRakebackInfo.setOrderTotalAmount(orderTotalAmount);
        BigDecimal parentRakeBackAmount = atinRakebackInfo.getParentRakebackAmount();
        parentRakeBackAmount = parentRakeBackAmount.add(atinRakebackRecord.getParentRakebackAmount());
        atinRakebackInfo.setParentRakebackAmount(parentRakeBackAmount);
        AtinAllowanceRecord atinAllowanceRecord = new AtinAllowanceRecord();
        atinAllowanceRecord.setUserId(parentUser.getId());
        atinAllowanceRecord.setChildId(user.getId());
        atinAllowanceRecord.setPlatTciScale(atinRakebackRecord.getParentRakebackTciRate());
        atinAllowanceRecord.setPlatVciScale(atinRakebackRecord.getParentRakebackVciRate());
        atinAllowanceRecord.setOrderId(lbOrder.getId());
        atinAllowanceRecord.setAllowanceAmount(atinRakebackRecord.getParentRakebackAmount());
        atinAllowanceRecord.setCreateTime(new Date());
        this.atinAllowanceRecordMapper.insertSelective(atinAllowanceRecord);
    }

    private InsureConfirmReqDto getInsureConfirmReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        InsureConfirmReqDto insureConfirmReqDto = new InsureConfirmReqDto();
        PolicyDto policy = orderInfoDto.getPolicyDto();
        BeanUtil.quickCopy((Object)((Object)policy), (Object)insureConfirmReqDto);
        insureConfirmReqDto.setQuoteNo(policy.getQueryNo());
        insureConfirmReqDto.setPostName(orderInfoDto.getOrderRoles().getPostContact());
        insureConfirmReqDto.setPostAddr(orderInfoDto.getOrderRoles().getPostAddress());
        insureConfirmReqDto.setPostMobile(orderInfoDto.getOrderRoles().getPostMobile());
        return insureConfirmReqDto;
    }

    private IdentityCollectReqDto getIdentityCollectReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        IdentityCollectReqDto identityCollectReqDto = new IdentityCollectReqDto();
        PolicyDto policy = orderInfoDto.getPolicyDto();
        BeanUtil.quickCopy((Object)((Object)policy), (Object)identityCollectReqDto);
        identityCollectReqDto.setQuoteNo(policy.getQueryNo());
        identityCollectReqDto.setInsuCom(orderInfoDto.getPolicyDto().getInsuCom());
        identityCollectReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(orderInfoDto.getPolicyDto().getLicenseNo()));
        return identityCollectReqDto;
    }

    private LuoberPayReqDto getLuoberPayReqDtoByOrderInfo(OrderInfoDto orderInfoDto) {
        LuoberPayReqDto luoberPayReqDto = new LuoberPayReqDto();
        AtinOrderRoles orderRoles = orderInfoDto.getOrderRoles();
        PolicyDto policyDto = orderInfoDto.getPolicyDto();
        luoberPayReqDto.setChannel(ChannelConstants.CHANNEL);
        luoberPayReqDto.setInsuCom(policyDto.getInsuCom());
        luoberPayReqDto.setInnerPlcyNo(policyDto.getInnerPlcyNo());
        luoberPayReqDto.setChargeComCode("WX");
        luoberPayReqDto.setOpenId(orderInfoDto.getOrderRoles().getOpenid());
        luoberPayReqDto.setAmount(Integer.valueOf(1));
        return luoberPayReqDto;
    }

    @Override
    public void cancelTodayOrder() {
        List todayPolicy = this.policyMapper.getPolicyListByStartDate(ServiceUtil.getTimesmorning(), ServiceUtil.getTimesnight());
        ArrayList<Integer> policyIdList = new ArrayList<Integer>();
        for (AtinPolicy policy : todayPolicy) {
            policyIdList.add(policy.getId());
        }
        if (CommonUtil.isEmpty(policyIdList)) {
            return;
        }
        List orderList = this.orderMapper.getOrderListByPolicyIdList(policyIdList);
        ArrayList<AtinOrder> result = new ArrayList<AtinOrder>();
        for (AtinOrder order : orderList) {
            if (order.getOrderStatus().intValue() != AtinOrder.ORDER_STATUS_SUBMIT.intValue() && order.getOrderStatus().intValue() != AtinOrder.ORDER_STATUS_SUBMIT_SUCCESS.intValue()) continue;
            result.add(order);
        }
        this.cancelOrder(result);
    }

    @Override
    public void cancelTimeOutOrder() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.add(11, -23);
        List orderList = this.orderMapper.getCancelOrderListBeforeTime(rightNow.getTime());
        this.cancelOrder(orderList);
    }

    private void cancelOrder(List<AtinOrder> orderList) {
        ArrayList<Integer> orderIdList = new ArrayList<Integer>();
        ArrayList<AtinOrderAction> orderActionList = new ArrayList<AtinOrderAction>();
        Date now = new Date();
        for (AtinOrder order : orderList) {
            orderIdList.add(order.getId());
            AtinOrderAction orderAction = new AtinOrderAction();
            orderAction.setOrderId(order.getId());
            BeanUtil.quickCopy((Object)order, (Object)orderAction);
            orderAction.setId(null);
            orderAction.setOrderStatus(AtinOrder.ORDER_STATUS_TIMEOUT);
            orderAction.setCreateTime(now);
            orderAction.setActionUser("\u7cfb\u7edf");
            orderAction.setActionContent("\u8d85\u65f6\u5173\u95ed\u8ba2\u5355");
            orderAction.setActionNote("");
            orderActionList.add(orderAction);
        }
        if (CommonUtil.isEmpty(orderIdList)) {
            return;
        }
        this.orderActionMapper.batchInsert(orderActionList);
        this.orderMapper.changeOrderStatusByOrderIdList(orderIdList, AtinOrder.ORDER_STATUS_TIMEOUT);
    }

    @Override
    public AtinOrderRoles getOrderRolesByOpenId(String openId) {
        AtinOrderRoles orderRoles = this.orderRolesMapper.selectUserOrderByOpenId(openId);
        return orderRoles;
    }

    @Override
    public String getIdentityCollectPhoneByOrderId(Integer orderId) {
        AtinOrder order = (AtinOrder)this.orderMapper.selectByPrimaryKey(orderId);
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(order.getOrderRolesId());
        return orderRoles == null ? "" : orderRoles.getApplicantMobile();
    }

    @Override
    public Page<OrderDto> getOrderDtoListByPayStatus(Integer pageNo, Integer pageSize, Integer payStatus, Integer orderType, Integer agencyId) {
        Integer totalOrder = 0;
        Page result = new Page();
        ArrayList<OrderDto> orderDtos = new ArrayList<OrderDto>();
        totalOrder = this.orderMapper.getTotalOrderNum(orderType, payStatus, agencyId);
        List list = this.orderMapper.getCurrentOrderList(orderType, payStatus, Integer.valueOf((pageNo - 1) * pageSize), pageSize, agencyId);
        for (AtinOrder order : list) {
            OrderDto dto = new OrderDto();
            BeanUtil.quickCopy((Object)order, (Object)((Object)dto));
            AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order.getPolicyId());
            if (null != policy) {
                AtinInsurer insurer = ServiceUtil.getInsurerByCode(policy.getInsuCom());
                dto.setInsuComName(insurer.getAbbreviation());
                dto.setLicenseNo(policy.getLicenseNo());
            }
            orderDtos.add(dto);
        }
        result.setPageNo(pageNo.intValue());
        result.setPageSize(pageSize.intValue());
        result.setTotalRecord((long)totalOrder.intValue());
        result.setTotalPage(totalOrder % pageSize == 0 ? totalOrder / pageSize : totalOrder / pageSize + 1);
        result.setResults(orderDtos);
        return result;
    }

    @Override
    public Page<OrderDto> getOrderDtoListByLicenseNo(Integer pageNo, Integer pageSize, String licenseNo, Integer orderType, Integer agencyId) {
        Integer totalNum = new Integer(0);
        ArrayList<OrderDto> list = new ArrayList<OrderDto>();
        List policyList = this.policyMapper.CountSelectByLicenseNo(licenseNo, orderType, agencyId);
        ArrayList<Integer> policyIds = new ArrayList<Integer>();
        for (AtinPolicy policy : policyList) {
            policyIds.add(policy.getId());
        }
        if (CommonUtil.isNotEmpty(policyIds) && (totalNum = this.orderMapper.getCountByPolicyIds(policyIds)) > 0) {
            List orders = this.orderMapper.findOrderListByPolicyIds(policyIds, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            for (AtinOrder order1 : orders) {
                OrderDto orderDto = new OrderDto();
                BeanUtil.quickCopy((Object)order1, (Object)((Object)orderDto));
                AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order1.getPolicyId());
                orderDto.setLicenseNo(policy.getLicenseNo());
                list.add(orderDto);
            }
        }
        Page orderDtoPage = new Page();
        orderDtoPage.setPageNo(pageNo.intValue());
        orderDtoPage.setPageSize(pageSize.intValue());
        if (CommonUtil.isNotEmpty(list)) {
            orderDtoPage.setTotalRecord((long)totalNum.intValue());
            orderDtoPage.setTotalPage(totalNum % pageSize == 0 ? totalNum / pageSize : totalNum / pageSize + 1);
        } else {
            orderDtoPage.setTotalPage(0);
            orderDtoPage.setTotalRecord(0L);
        }
        orderDtoPage.setResults(list);
        return orderDtoPage;
    }

    @Override
    public int savePostInfoToOrderRoles(Integer orderId, Integer agentId, String postName, String postAddr, String postMobile) {
        AtinOrder order = (AtinOrder)this.getByID(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order.getPolicyId());
        if (null != agentId) {
            policy.setAgentId(agentId);
            this.policyMapper.updateByPrimaryKey((Object)policy);
        }
        Integer orderRolesId = order.getOrderRolesId();
        AtinOrderRoles orderRoles = (AtinOrderRoles)this.orderRolesMapper.selectByPrimaryKey(orderRolesId);
        orderRoles.setPostMobile(postMobile);
        orderRoles.setPostAddress(postAddr);
        orderRoles.setPostContact(postName);
        return this.orderRolesMapper.updateByPrimaryKey((Object)orderRoles);
    }

    @Override
    public NotifyPayResultResDto notifyZeus(Integer orderId) {
        NotifyPayResultReqDto notifyPayResultReqDto = new NotifyPayResultReqDto();
        AtinOrder order = (AtinOrder)this.orderMapper.selectByPrimaryKey(orderId);
        AtinPolicy policy = (AtinPolicy)this.policyMapper.selectByPrimaryKey(order.getPolicyId());
        notifyPayResultReqDto.setChannel(ChannelConstants.CHANNEL);
        notifyPayResultReqDto.setCityCode(ServiceUtil.getCityCodeByLicenseNo(policy.getLicenseNo()));
        notifyPayResultReqDto.setInsuCom(policy.getInsuCom());
        notifyPayResultReqDto.setOrigin(ChannelConstants.CHANNEL);
        notifyPayResultReqDto.setPartner("zhlh");
        notifyPayResultReqDto.setTotalFee(Integer.valueOf(order.getNetFeePremium().intValue()));
        notifyPayResultReqDto.setInnerPlcyNo(policy.getInnerPlcyNo());
        notifyPayResultReqDto.setChargeComCode("offline");
        NotifyPayResultResDto notifyPayResultResDto = this.notifyPayResultRService.notifyPayResult(notifyPayResultReqDto);
        log.info("\u652f\u4ed8\u901a\u77e5zeus\u8fd4\u56de\u7ed3\u679c" + JsonUtil.beanToJSON((Object)notifyPayResultResDto));
        return notifyPayResultResDto;
    }

    private Map calcExpireTime(AtinOrder order) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.set(11, 23);
        rightNow.set(12, 59);
        rightNow.set(13, 59);
        long expireTime = rightNow.getTime().getTime();
        long h = (expireTime - new Date().getTime()) / 3600000L;
        long m = (expireTime - new Date().getTime()) / 60000L % 60L;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("hour", h);
        map.put("min", m);
        return map;
    }
}

