/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.common;

import com.zhlh.Tiny.util.CityLicense;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.DateUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.Tiny.util.Md5Util;
import com.zhlh.Tiny.util.RedisUtil;
import com.zhlh.Tiny.util.RegexUtil;
import com.zhlh.karma.domain.model.AtinAgencySupportInsuc;
import com.zhlh.karma.domain.model.AtinCoverage;
import com.zhlh.karma.domain.model.AtinInsurer;
import com.zhlh.karma.dto.AgencyInsuComListDto;
import com.zhlh.karma.dto.QuotePriceResultDto;
import com.zhlh.karma.service.common.ServiceCache;
import com.zhlh.karma.service.constant.ChannelConstants;
import com.zhlh.zeus.dto.quote.CoverageDataDto;
import com.zhlh.zeus.dto.quote.QuotePriceReqDto;
import com.zhlh.zeus.dto.quote.QuotePriceResDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtil.class);
    private static Integer addNum = 0;

    public static Date getTimesmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTimesnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        cal.add(14, -1);
        return cal.getTime();
    }

    private static String convert(String cityCode) {
        Object[] specialCity = new String[]{"4403", "3702", "2102", "3302", "3205", "3502", "5001"};
        Object[] specialPro = new String[]{"11", "12", "31", "71"};
        String four = cityCode.substring(0, 4);
        String two = cityCode.substring(0, 2);
        return ArrayUtils.contains((Object[])specialCity, (Object)four) ? four + "00" : two + (ArrayUtils.contains((Object[])specialPro, (Object)two) ? "0000" : "0100");
    }

    public static AtinCoverage getCoverageByCode(String coverageCode) {
        Map coverageMap = (Map)ServiceCache.SERVICE_CACHE.get("coverage");
        return (AtinCoverage)coverageMap.get(coverageCode);
    }

    public static AtinInsurer getInsurerByCode(String insurerCode) {
        Map insurerMap = (Map)ServiceCache.SERVICE_CACHE.get("insurer");
        log.info("insurerMap:" + JsonUtil.beanToJSON((Object)insurerMap));
        return (AtinInsurer)insurerMap.get(insurerCode);
    }

    public static List<AtinAgencySupportInsuc> getAgencySupportInsurer() {
        return (List)ServiceCache.SERVICE_CACHE.get("agency_insu_com");
    }

    public static List<AtinAgencySupportInsuc> getSupportInsurer(String licenseNo) {
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insu_com_city");
        log.info("licenseNo" + licenseNo);
        String shortLicenseNo = licenseNo.substring(0, 2);
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        return insuComCityList == null ? new ArrayList() : insuComCityList;
    }

    public static Boolean isSupportByInsurerCode(String insurerCode, String licenseNo) {
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insu_com_city");
        log.info("licenseNo" + licenseNo);
        String shortLicenseNo = licenseNo.substring(0, 2);
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        for (AtinAgencySupportInsuc insuComCity : insuComCityList) {
            if (!insuComCity.getInsuCom().equals(insurerCode)) continue;
            return true;
        }
        return false;
    }

    public static BigDecimal getAgencyDiscount(String insurerCode, String licenseNo, Integer agencyId) {
        String shortLicenseNo;
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insu_com_city");
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo = licenseNo.substring(0, 2));
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        for (AtinAgencySupportInsuc insuComCity : insuComCityList) {
            if (!insurerCode.equals(insuComCity.getInsuCom()) || agencyId != insuComCity.getAgencyId()) continue;
            return insuComCity.getDiscount();
        }
        return new BigDecimal("0");
    }

    public static AtinAgencySupportInsuc getAgencySupportInsuc(String insurerCode, String licenseNo, Integer agencyId) {
        String shortLicenseNo;
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insu_com_city");
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo = licenseNo.substring(0, 2));
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        for (AtinAgencySupportInsuc insuComCity : insuComCityList) {
            if (!insurerCode.equals(insuComCity.getInsuCom()) || agencyId != insuComCity.getAgencyId()) continue;
            return insuComCity;
        }
        return new AtinAgencySupportInsuc();
    }

    public static BigDecimal getMarketPremium(String insurerCode, String licenseNo, BigDecimal premium) {
        String shortLicenseNo;
        Map insuComCityListMap = (Map)ServiceCache.SERVICE_CACHE.get("insu_com_city");
        List insuComCityList = (List)insuComCityListMap.get(shortLicenseNo = licenseNo.substring(0, 2));
        if (CommonUtil.isEmpty((Collection)insuComCityList)) {
            shortLicenseNo = licenseNo.substring(0, 1);
            insuComCityList = (List)insuComCityListMap.get(shortLicenseNo);
        }
        for (AtinAgencySupportInsuc insuComCity : insuComCityList) {
            if (!insurerCode.equals(insuComCity.getInsuCom())) continue;
            if (!"NetSales".equals(insuComCity.getType())) continue;
            return premium.divide(new BigDecimal(85), 2).multiply(new BigDecimal(100));
        }
        return premium;
    }

    public static boolean isBJVehicle(String licenseNo) {
        return licenseNo.startsWith("\u4eac");
    }

    public static String randomOrderSn() {
        String today = DateUtil.formatDate((Date)new Date(), (String)"yyMMdd");
        String second = String.valueOf(System.currentTimeMillis() / 1000L);
        String secondStr = second.substring(second.length() - 5);
        String num = ServiceUtil.getAddNum();
        return today + num + secondStr + ServiceUtil.getRandomNum();
    }

    private static synchronized String getAddNum() {
        addNum = addNum < 999 ? addNum + 1 : 0;
        return String.format("%03d", addNum);
    }

    private static String getRandomNum() {
        return String.format("%02d", new Random().nextInt(99));
    }

    public static BigDecimal getBigDecimal(String value) {
        if (!CommonUtil.isEmpty((String)value) && RegexUtil.checkDecimals((String)value)) {
            return new BigDecimal(value);
        }
        return new BigDecimal(0);
    }

    public static String convertAmount(String str) {
        if (CommonUtil.isNotEmpty((String)str) && str.contains("\u4e07")) {
            str = str.substring(0, str.length() - 1);
            Integer amount = new Integer(str);
            amount = amount * 10000;
            return String.valueOf(amount);
        }
        return str;
    }

    public static String formatStartDate(String startDate) {
        if (startDate.contains("/")) {
            Date date = DateUtil.parseDate((String)startDate, (String)"yyyy/MM/dd");
            startDate = DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd");
        }
        return startDate;
    }

    public static void saveQuoteReqDtoRedis(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        if (quotePriceReqDto != null) {
            quotePriceReqDto.setIsInsureConfirm(Integer.valueOf(0));
            quotePriceReqDto.setOwnerData(null);
            quotePriceReqDto.setInsurantData(null);
            quotePriceReqDto.setPolicyHolderData(null);
            if (quotePriceReqDto.getCoverageDataDtoList() != null) {
                for (CoverageDataDto coverageDataDto : quotePriceReqDto.getCoverageDataDtoList()) {
                    if ("BZ,A,G1,X1,Z,M,Q5".contains(coverageDataDto.getCoverageCode()) && !"B".equals(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setAmount(null);
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setUnitAmount(null);
                        coverageDataDto.setModeCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                    }
                    if ("B,L".contains(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setUnitAmount(null);
                        coverageDataDto.setModeCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                    }
                    if ("D3,D4".contains(coverageDataDto.getCoverageCode())) {
                        coverageDataDto.setAmount(null);
                        coverageDataDto.setQuantity(null);
                        coverageDataDto.setModeCode(null);
                        coverageDataDto.setReason(null);
                        coverageDataDto.setBenchmarkPremium(null);
                        coverageDataDto.setPremium(null);
                    }
                    if (!"F".contains(coverageDataDto.getCoverageCode())) continue;
                    coverageDataDto.setAmount(null);
                    coverageDataDto.setUnitAmount(null);
                    coverageDataDto.setQuantity(null);
                    coverageDataDto.setReason(null);
                    coverageDataDto.setBenchmarkPremium(null);
                    coverageDataDto.setPremium(null);
                }
            }
        }
        RedisUtil.put((Serializable)((Object)"quotation"), (Serializable)((Object)(ChannelConstants.CHANNEL + "userId." + userId)), (Object)quotePriceReqDto);
    }

    public static void saveQuoteReqCustomDtoRedis(QuotePriceReqDto quotePriceReqDto, Integer userId) {
        RedisUtil.put((Serializable)((Object)"quotation"), (Serializable)((Object)(ChannelConstants.CHANNEL + "userId." + userId)), (Object)quotePriceReqDto);
    }

    public static QuotePriceReqDto getQuoteReqDtoFromRedis(Integer userId) {
        return (QuotePriceReqDto)RedisUtil.get((Serializable)((Object)"quotation"), (Serializable)((Object)(ChannelConstants.CHANNEL + "userId." + userId)), QuotePriceReqDto.class);
    }

    public static void saveQuoteResultDtoToRedis(QuotePriceResultDto quotePriceResultDto, Integer userId, Integer agencyId) {
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)(ChannelConstants.CHANNEL + "agency." + agencyId + "userId." + userId)), (Object)quotePriceResultDto);
    }

    public static QuotePriceResultDto getQuoteResultDtoFromRedis(Integer userId, Integer agencyId) {
        return (QuotePriceResultDto)RedisUtil.get((Serializable)((Object)"quoteResult"), (Serializable)((Object)(ChannelConstants.CHANNEL + "agency." + agencyId + "userId." + userId)), QuotePriceResultDto.class);
    }

    public static void saveSelectAgencyInsuComToRedis(Integer userId, AgencyInsuComListDto agencyListDto) {
        RedisUtil.put((Serializable)((Object)"agency"), (Serializable)((Object)("userId." + userId)), (Object)agencyListDto);
    }

    public static AgencyInsuComListDto getSelectAgencyInsuComFromRedis(Integer userId) {
        return (AgencyInsuComListDto)RedisUtil.get((Serializable)((Object)"agency"), (Serializable)((Object)("userId." + userId)), AgencyInsuComListDto.class);
    }

    public static void resetQuoteResultDtoToRedis(Integer userId) {
        QuotePriceResultDto quotePriceResultDto = new QuotePriceResultDto();
        HashMap<String, QuotePriceResDto> resultMap = new HashMap<String, QuotePriceResDto>();
        quotePriceResultDto.setQuoteQueryStr("");
        quotePriceResultDto.setResultMap(resultMap);
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("easy.userId." + userId)), (Object)quotePriceResultDto);
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("usual.userId." + userId)), (Object)quotePriceResultDto);
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("total.userId." + userId)), (Object)quotePriceResultDto);
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("custom.userId." + userId)), (Object)quotePriceResultDto);
        RedisUtil.put((Serializable)((Object)"quoteResult"), (Serializable)((Object)("userId." + userId)), (Object)quotePriceResultDto);
    }

    public static Integer convertAmountInt(String str) {
        if (CommonUtil.isNotEmpty((String)str) && str.contains("\u4e07")) {
            str = str.substring(0, str.length() - 1);
            Integer amount = new Integer(str);
            amount = amount * 10000;
            return amount;
        }
        if (CommonUtil.isNotEmpty((String)str) && !str.contains("\u4e0d\u6295\u4fdd")) {
            Integer amount = new Integer(str);
            return amount;
        }
        return 0;
    }

    public static String getCityCodeByLicenseNo(String licenseNo) {
        if (CommonUtil.isEmpty((String)licenseNo)) {
            return "";
        }
        String cityCode = CityLicense.getCityCodeByLicense((String)licenseNo);
        return CommonUtil.isEmpty((String)(cityCode = ServiceUtil.convert(cityCode))) ? "" : cityCode;
    }

    public static String getQuoteQueryStr(QuotePriceReqDto quotePriceReqDto) {
        String quoteQueryStr = JsonUtil.beanToJSON((Object)quotePriceReqDto);
        return Md5Util.md5AsLowerHex((String)quoteQueryStr);
    }

    public static Integer getSortNum(String coverageCode) {
        switch (coverageCode) {
            case "BZ": {
                return 0;
            }
            case "A": {
                return 1;
            }
            case "B": {
                return 2;
            }
            case "G1": {
                return 3;
            }
            case "D3": {
                return 4;
            }
            case "D4": {
                return 5;
            }
            case "L": {
                return 6;
            }
            case "F": {
                return 7;
            }
            case "X1": {
                return 8;
            }
            case "Z": {
                return 9;
            }
            case "Q5": {
                return 10;
            }
            case "M": {
                return 11;
            }
        }
        return 12;
    }

    public static Integer getSortNumInsurer(String insurerCode) {
        switch (insurerCode) {
            case "I00001": {
                return 0;
            }
            case "I00027": {
                return 1;
            }
            case "I00002": {
                return 2;
            }
            case "I00019": {
                return 3;
            }
            case "I00009": {
                return 4;
            }
            case "I00028": {
                return 5;
            }
            case "I00008": {
                return 6;
            }
        }
        return 10;
    }
}

