/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.karma.service.common;

import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.karma.service.constant.ChannelConstants;
import com.zhlh.karma.util.ErrorMessageUtil;
import com.zhlh.zeus.dto.BaseResDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageConvert {
    private static final Logger LOG = LoggerFactory.getLogger((String)"http");
    private static List<Convert> convertList = new ArrayList<Convert>();

    public static void errorConvert(Object baseRes) {
        BaseResDto baseResDto = (BaseResDto)baseRes;
        if (baseResDto.getErrCode() == 0) {
            return;
        }
        for (Convert convert : convertList) {
            if (convert.convert(baseResDto)) break;
        }
    }

    static {
        convertList.add(new Convert(10000, 20000, "USER", ""));
        convertList.add(new Convert(20000, 30000, "USER", "\u592a\u96be\u4e86,\u7a0b\u5e8f\u733f\u5df2\u54ed\u6655"));
        convertList.add(new Convert(30000, 40000, "USER", ""));
        convertList.add(new Convert(40000, 50000, "USER", "\u592a\u96be\u4e86,\u7a0b\u5e8f\u733f\u5df2\u54ed\u6655"));
        convertList.add(new Convert(50000, 60000, "SYS", "\u4fdd\u9669\u516c\u53f8\u4e0d\u7ed9\u529b"));
        convertList.add(new Convert(60000, 99999, "SYS", "\u592a\u96be\u4e86,\u7a0b\u5e8f\u733f\u5df2\u54ed\u6655"));
    }

    static class Convert {
        static final String TYPE_USER = "USER";
        static final String TYPE_SYS = "SYS";
        int minCode;
        int maxCode;
        String type;
        String message;

        Convert(int minCode, int maxCode, String type, String message) {
            this.minCode = minCode;
            this.maxCode = maxCode;
            this.type = type;
            this.message = message;
        }

        boolean convert(BaseResDto baseResDto) {
            Integer errCode = baseResDto.getErrCode();
            String errMsg = baseResDto.getErrMsg();
            if (this.minCode <= errCode && this.maxCode > errCode) {
                String errInfoMsg;
                switch (this.type) {
                    case "USER": {
                        baseResDto.setErrMsg(errMsg);
                        break;
                    }
                    case "SYS": {
                        baseResDto.setErrMsg(this.message);
                    }
                }
                if (!"Saas".equals(ChannelConstants.CHANNEL) && CommonUtil.isNotEmpty((String)(errInfoMsg = ErrorMessageUtil.errorConvert(baseResDto.getErrMsg())))) {
                    baseResDto.setErrMsg(errInfoMsg);
                }
                return true;
            }
            return false;
        }
    }
}

