/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.hermes.mongo.dao;

import com.zhlh.hermes.mongo.dao.IBaseDao;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;

public abstract class BaseDaoImpl<T>
implements IBaseDao<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;

    protected abstract Class<T> getEntityClass();

    @Override
    public void save(T entity) {
        this.mongoTemplate.save(entity);
    }

    @Override
    public void update(T entity) {
        Map<String, Object> map = null;
        try {
            map = this.parseEntity(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String id = null;
        Object value = null;
        Update update = new Update();
        if (map != null && map.size() > 0) {
            for (String key : map.keySet()) {
                if (key.startsWith("{")) {
                    id = key.substring(key.indexOf("{") + 1, key.indexOf("}"));
                    value = map.get(key);
                    continue;
                }
                update.set(key, map.get(key));
            }
        }
        this.mongoTemplate.updateFirst(new Query().addCriteria((CriteriaDefinition)Criteria.where(id).is(value)), update, this.getEntityClass());
    }

    @Override
    public void delete(Serializable ... ids) {
        if (ids != null && ids.length > 0) {
            for (Serializable id : ids) {
                this.mongoTemplate.remove(this.mongoTemplate.findById((Object)id, this.getEntityClass()));
            }
        }
    }

    @Override
    public T find(Serializable id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    @Override
    public List findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    @Override
    public List<T> findAll(String order) {
        List<Sort.Order> orderList = this.parseOrder(order);
        if (orderList == null || orderList.size() == 0) {
            return this.findAll();
        }
        return this.mongoTemplate.find(new Query().with(new Sort(orderList)), this.getEntityClass());
    }

    @Override
    public List<T> findByProp(String propName, Object value) {
        return this.findByProp(propName, value, null);
    }

    @Override
    public List<T> findByProp(String propName, Object value, String order) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)propName).is(value));
        List<Sort.Order> orderList = this.parseOrder(order);
        if (orderList != null && orderList.size() > 0) {
            query.with(new Sort(orderList));
        }
        return null;
    }

    @Override
    public List<T> findByProps(String[] propName, Object[] values) {
        return this.findByProps(propName, values, null);
    }

    @Override
    public List<T> findByProps(String[] propName, Object[] values, String order) {
        Query query = this.createQuery(propName, values, order);
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    @Override
    public T uniqueByProp(String propName, Object value) {
        return (T)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)propName).is(value)), this.getEntityClass());
    }

    @Override
    public T uniqueByProps(String[] propName, Object[] values) {
        Query query = this.createQuery(propName, values, null);
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    @Override
    public int countByCondition(String[] params, Object[] values) {
        Query query = this.createQuery(params, values, null);
        Long count = this.mongoTemplate.count(query, this.getEntityClass());
        return count.intValue();
    }

    protected Map<String, Object> parseEntity(T t) throws Exception {
        Field[] declaredFields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String id = "";
        for (Field field : declaredFields = this.getEntityClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            field.setAccessible(Boolean.TRUE);
            map.put("{" + field.getName() + "}", field.get(t));
            id = field.getName();
            break;
        }
        Method[] declaredMethods = this.getEntityClass().getDeclaredMethods();
        if (declaredFields != null && declaredFields.length > 0) {
            for (Method method : declaredMethods) {
                String fieldName;
                if (!method.getName().startsWith("get") || method.getModifiers() != 1 || (fieldName = this.parse2FieldName(method.getName())).equals(id)) continue;
                map.put(fieldName, method.invoke(t, new Object[0]));
            }
        }
        return map;
    }

    private String parse2FieldName(String method) {
        String name = method.replace("get", "");
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public Query createQuery(String[] propName, Object[] values, String order) {
        List<Sort.Order> orderList;
        Query query = new Query();
        if (propName != null && values != null) {
            for (int i = 0; i < propName.length; ++i) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)propName[i]).is(values[i]));
            }
        }
        if ((orderList = this.parseOrder(order)) != null && orderList.size() > 0) {
            query.with(new Sort(orderList));
        }
        return query;
    }

    public List<Sort.Order> parseOrder(String order) {
        ArrayList<Sort.Order> list = null;
        if (order != null && !"".equals(order)) {
            list = new ArrayList<Sort.Order>();
            String[] fields = order.split(",");
            Sort.Order o = null;
            String[] items = null;
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] == null) continue;
                items = fields[i].split(" ");
                if (items.length == 1) {
                    o = new Sort.Order(Sort.Direction.ASC, items[0]);
                } else if (items.length == 2) {
                    o = new Sort.Order("desc".equalsIgnoreCase(items[1]) ? Sort.Direction.DESC : Sort.Direction.ASC, items[0]);
                } else {
                    throw new RuntimeException("order field parse error");
                }
                list.add(o);
            }
        }
        return list;
    }

    public static <T> Page<T> getPage(List<T> content, Pageable pageable, TotalSupplier totalSupplier) {
        Assert.notNull(content, (String)"Content must not be null!");
        Assert.notNull((Object)totalSupplier, (String)"TotalSupplier must not be null!");
        if (pageable == null || pageable.getOffset() == 0) {
            if (pageable == null || pageable.getPageSize() > content.size()) {
                return new PageImpl(content, pageable, (long)content.size());
            }
            return new PageImpl(content, pageable, totalSupplier.get());
        }
        if (content.size() != 0 && pageable.getPageSize() > content.size()) {
            return new PageImpl(content, pageable, (long)(pageable.getOffset() + content.size()));
        }
        return new PageImpl(content, pageable, totalSupplier.get());
    }

    public static interface TotalSupplier {
        public long get();
    }
}

