/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();

    public static String getCookieStr(String url, String content, String charset) throws IOException {
        String result = "";
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        HttpUtil.doPost(url, (HttpEntity)entity, null, charset, basicCookieStore);
        List cookies = basicCookieStore.getCookies();
        for (Cookie cookie : cookies) {
            result = result + cookie.getName() + "=" + cookie.getValue() + "; ";
        }
        return result;
    }

    public static String doPost(String url, String content, List<Header> headers) {
        return HttpUtil.doPost(url, content, headers, DEFAULT_CHARSET);
    }

    public static String doPost(String url, Map<String, String> params, List<Header> headers) {
        return HttpUtil.doPost(url, params, headers, DEFAULT_CHARSET);
    }

    public static String doPostJson(String url, String json, List<Header> headers, String charset) throws Exception {
        Map params = (Map)JSONObject.parseObject((String)json, Map.class);
        return HttpUtil.doPost(url, params, headers, charset);
    }

    public static String doPost(String url, String content, List<Header> headers, String charset) {
        StringEntity entity = new StringEntity(content, Charset.forName(charset));
        try {
            return HttpUtil.doPost(url, (HttpEntity)entity, headers, charset, null);
        }
        catch (IOException e) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + e.getMessage());
        }
    }

    public static String doPost(String url, Map<String, String> params, List<Header> headers, String charset) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            nameValuePairs.add(new BasicNameValuePair(key, val));
        }
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, charset);
            return HttpUtil.doPost(url, (HttpEntity)entity, headers, charset, null);
        }
        catch (Exception e) {
            throw new RuntimeException("doPost\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + e.getMessage());
        }
    }

    public static String doGet(String url, final String charset) {
        String responseBody = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        try {
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)charset) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            responseBody = (String)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException("doGet\u8bf7\u6c42\u5931\u8d25\uff0curl\u4e3a\uff1a" + url + ", \u539f\u56e0:" + e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseBody;
    }

    public static String doGet(String url, Map<String, String> params, String charset) {
        if (params != null && params.size() != 0) {
            url = url + "?";
            Set<String> keys = params.keySet();
            for (String key : keys) {
                url = url + key + "=" + params.get(key) + "&";
            }
            url = url.substring(0, url.length() - 1);
        }
        return HttpUtil.doGet(url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, HttpEntity httpEntity, List<Header> headers, final String charset, BasicCookieStore basicCookieStore) throws IOException {
        CloseableHttpClient httpClient = basicCookieStore != null ? HttpClients.custom().setDefaultCookieStore((CookieStore)basicCookieStore).build() : HttpClients.createDefault();
        String responseBody = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(httpEntity);
        if (headers != null && headers.size() > 0) {
            Header[] headerArr = new Header[headers.size()];
            httpPost.setHeaders(headers.toArray(headerArr));
        }
        try {
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            return EntityUtils.toString((HttpEntity)entity, (String)charset);
                        }
                        throw new ClientProtocolException("Response entity is null");
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            responseBody = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCookie(String url, final String charset) throws IOException {
        String jsessionId = null;
        ArrayList nameValuePairs = new ArrayList();
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValuePairs, charset);
        ArrayList headers = new ArrayList();
        String responseBody = null;
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)basicCookieStore).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)httpEntity);
        if (headers != null && headers.size() > 0) {
            Header[] headerArr = new Header[headers.size()];
            httpPost.setHeaders(headers.toArray(headerArr));
        }
        try {
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            return EntityUtils.toString((HttpEntity)entity, (String)charset);
                        }
                        throw new ClientProtocolException("Response entity is null");
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            responseBody = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List cookies = basicCookieStore.getCookies();
        for (Cookie cookie : cookies) {
            if (!"JSESSIONID".equals(cookie.getName())) continue;
            jsessionId = cookie.getName() + "=" + cookie.getValue();
            break;
        }
        return jsessionId;
    }
}

