/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.aspect;

import com.alibaba.fastjson.JSON;
import com.zhlh.Tiny.util.BeanUtil;
import com.zhlh.Tiny.util.RegexUtil;
import com.zhlh.gaia.common.exception.ErrorCode;
import com.zhlh.gaia.common.exception.ExceptionHelper;
import com.zhlh.gaia.common.util.CityCodeConvert;
import com.zhlh.gaia.common.util.PartnerUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ServiceAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAspect.class);

    @Around(value="execution(public * com.zhlh.gaia.api.CarInsuranceService.*(..))")
    public Object aroundServiceMethod(ProceedingJoinPoint pjp) {
        Object returnVal;
        long start = System.currentTimeMillis();
        String implName = pjp.getTarget().getClass().getSimpleName();
        String serviceName = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
        try {
            this.checkParam(pjp.getArgs());
            returnVal = pjp.proceed();
        }
        catch (Throwable throwable) {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            Method method = signature.getMethod();
            Class<?> returnType = method.getReturnType();
            returnVal = BeanUtil.invokeNewInstance(returnType);
            ExceptionHelper.transErrorMsg(throwable, returnVal);
        }
        LOG.info("[Service]: {}, [implName]: {}, [Args]: {}, [Return]: {}, [Cost]: {}.", new Object[]{serviceName, implName, JSON.toJSONString((Object)pjp.getArgs()), JSON.toJSONString((Object)returnVal), System.currentTimeMillis() - start + "ms"});
        return returnVal;
    }

    private void checkParam(Object[] args) {
        if (args.length == 0) {
            return;
        }
        Object reqDto = args[0];
        String partner = (String)BeanUtil.invokeGetter((String)"partner", (Object)reqDto);
        String cityCode = (String)BeanUtil.invokeGetter((String)"cityCode", (Object)reqDto);
        String insuComCode = (String)BeanUtil.invokeGetter((String)"insuCom", (Object)reqDto);
        ExceptionHelper.notEmpty(insuComCode, ErrorCode.Param_Empty_InsureCode);
        ExceptionHelper.notEmpty(cityCode, ErrorCode.Param_Empty_CityCode);
        ExceptionHelper.beTrue(RegexUtil.checkDigit((String)cityCode), ErrorCode.Param_Error_CityCode);
        ExceptionHelper.notEmpty(partner, ErrorCode.Param_Empty_Parnter);
        cityCode = CityCodeConvert.convert(cityCode);
        ExceptionHelper.notEmpty(PartnerUtil.getPartnerConfig(partner, insuComCode, cityCode), ErrorCode.PARTNER_ERROR);
    }
}

