/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.gaia.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanUtil {
    public static Map<String, String> objectToMap(Object javaBean, boolean isFilterBlank) {
        Method[] methods;
        HashMap<String, String> result = new HashMap<String, String>();
        for (Method method : methods = javaBean.getClass().getDeclaredMethods()) {
            try {
                if (!method.getName().startsWith("get")) continue;
                String field = method.getName();
                field = field.substring(field.indexOf("get") + 3);
                field = field.toLowerCase().charAt(0) + field.substring(1);
                String value = (String)method.invoke(javaBean, (Object[])null);
                if (isFilterBlank) {
                    if (value == null) continue;
                    result.put(field, value);
                    continue;
                }
                result.put(field, null == value ? "" : value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Map<String, Method> getAllGetters(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        LinkedHashMap<String, Method> getters = new LinkedHashMap<String, Method>();
        for (Method m : methods) {
            if (m.getGenericParameterTypes().length != 0) continue;
            if (m.getName().startsWith("get")) {
                getters.put(BeanUtil.lowerFirstLetter(m.getName().substring(3)), m);
                continue;
            }
            if (!m.getName().startsWith("is") || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class) continue;
            getters.put(BeanUtil.lowerFirstLetter(m.getName().substring(2)), m);
        }
        return getters;
    }

    public static Map<String, Method> getAllSetters(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        LinkedHashMap<String, Method> setters = new LinkedHashMap<String, Method>();
        for (Method method : methods) {
            Method m = method;
            if (!m.getName().startsWith("set") || m.getGenericParameterTypes().length != 1 || m.getReturnType() != Void.TYPE) continue;
            String fieldName = BeanUtil.lowerFirstLetter(m.getName().substring(3));
            if (null != BeanUtil.getGetter(clazz, fieldName) && BeanUtil.getGetter(clazz, fieldName).getReturnType() != m.getGenericParameterTypes()[0]) {
                try {
                    m = clazz.getMethod(m.getName(), BeanUtil.getGetter(clazz, fieldName).getReturnType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            setters.put(fieldName, m);
        }
        return setters;
    }

    public static Method getGetter(Class<?> clazz, String fieldName) {
        return BeanUtil.getAllGetters(clazz).get(fieldName);
    }

    public static Method getSetter(Class<?> clazz, String fieldName) {
        return BeanUtil.getAllSetters(clazz).get(fieldName);
    }

    public static void invokeSetter(String fieldName, Object target, Object value) {
        Method setter = BeanUtil.getAllSetters(target.getClass()).get(fieldName);
        if (null == setter) {
            throw new RuntimeException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684setter\uff1a" + fieldName);
        }
        BeanUtil.invokeMethod(setter, target, value);
    }

    public static Object invokeGetter(String fieldName, Object target) {
        Method getter = BeanUtil.getAllGetters(target.getClass()).get(fieldName);
        if (null == getter) {
            throw new RuntimeException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684getter\uff1a" + fieldName);
        }
        return BeanUtil.invokeMethod(getter, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        if (null == method) {
            throw new RuntimeException("\u8c03\u7528\u76ee\u6807" + target + "\u7684\u65b9\u6cd5\u65f6\uff0cMethod\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return method.invoke(target, args);
        }
        catch (Exception var4) {
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T invokeNewInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception var2) {
            throw new RuntimeException("\u8be5\u5c5e\u6027\u6240\u5bf9\u5e94\u7684\u7c7b\u6ca1\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\uff0c" + clazz.toString());
        }
    }

    public static String lowerFirstLetter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static void copy(Object fromObj, Object toObj) {
        Field[] fields;
        Class<?> fromClazz = fromObj.getClass();
        Class<?> toClazz = toObj.getClass();
        for (Field fromField : fields = fromClazz.getDeclaredFields()) {
            try {
                if (Modifier.isStatic(fromField.getModifiers())) continue;
                fromField.setAccessible(true);
                Object value = fromField.get(fromObj);
                if (value == null) continue;
                try {
                    Field toField = toClazz.getDeclaredField(fromField.getName());
                    toField.setAccessible(true);
                    toField.set(toObj, value);
                }
                catch (NoSuchFieldException e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

