/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.wechat.helper;

import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.util.ConvertUtil;
import com.zhlh.Tiny.util.HttpUtil;
import com.zhlh.Tiny.wechat.helper.WeiXinHelper;
import com.zhlh.Tiny.wechat.model.Article;
import com.zhlh.Tiny.wechat.model.Articles;
import com.zhlh.Tiny.wechat.model.SendAllMsgTypes;
import com.zhlh.Tiny.wechat.model.TemplateData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinMessageHelper {
    private static final Logger log = LoggerFactory.getLogger(WeiXinMessageHelper.class);
    private static final String MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";
    private static final String UPLOADNEWS_URL = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=";
    private static final String MASS_SENDALL_URL = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=";
    private static final String MASS_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=";
    private static final String MASS_DELETE_URL = "https://api.weixin.qq.com//cgi-bin/message/mass/delete?access_token=";
    private static final String TEMPLATE_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

    private static String sendMsg(Map<String, Object> message) {
        String accessToken = WeiXinHelper.getAccessToken();
        String info = JSONObject.toJSONString(message);
        info = info.replaceAll("picUrl", "picurl");
        info = info.replaceAll("PicUrl", "picurl");
        String result = HttpUtil.doPost(MESSAGE_URL.concat(accessToken), info);
        return result;
    }

    public static String sendText(String openId, String text) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> textObj = new HashMap<String, String>();
        String content = ConvertUtil.string2Bytes(text, "utf-8");
        textObj.put("content", content);
        json.put("touser", openId);
        json.put("msgtype", "text");
        json.put("text", textObj);
        String result = WeiXinMessageHelper.sendMsg(json);
        return result;
    }

    public static String sendImage(String openId, String media_id) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("media_id", media_id);
        json.put("touser", openId);
        json.put("msgtype", "image");
        json.put("image", textObj);
        String result = WeiXinMessageHelper.sendMsg(json);
        return result;
    }

    public static String sendVoice(String openId, String media_id) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("media_id", media_id);
        json.put("touser", openId);
        json.put("msgtype", "voice");
        json.put("voice", textObj);
        String result = WeiXinMessageHelper.sendMsg(json);
        return result;
    }

    public static String sendVideo(String openId, String media_id, String title, String description) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("media_id", media_id);
        textObj.put("title", title);
        textObj.put("description", description);
        json.put("touser", openId);
        json.put("msgtype", "video");
        json.put("video", textObj);
        String result = WeiXinMessageHelper.sendMsg(json);
        return result;
    }

    public static String sendMusic(String openId, String musicurl, String hqmusicurl, String thumb_media_id, String title, String description) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("musicurl", musicurl);
        textObj.put("hqmusicurl", hqmusicurl);
        textObj.put("thumb_media_id", thumb_media_id);
        textObj.put("title", title);
        textObj.put("description", description);
        json.put("touser", openId);
        json.put("msgtype", "music");
        json.put("music", textObj);
        String result = WeiXinMessageHelper.sendMsg(json);
        return result;
    }

    public static String sendNews(String openId, List<Articles> articles) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "news");
        HashMap<String, List<Articles>> news = new HashMap<String, List<Articles>>();
        news.put("articles", articles);
        json.put("news", news);
        return WeiXinMessageHelper.sendMsg(json);
    }

    public static String sendCoupon(String openId, String card_id, String card_ext) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "wxcard");
        HashMap<String, String> wxcard = new HashMap<String, String>();
        wxcard.put("card_id", card_id);
        wxcard.put("card_ext", card_ext);
        json.put("wxcard", wxcard);
        return WeiXinMessageHelper.sendMsg(json);
    }

    public static JSONObject uploadnews(List<Article> articles) throws IOException, ExecutionException, InterruptedException {
        String accessToken = WeiXinHelper.getAccessToken();
        HashMap<String, List<Article>> json = new HashMap<String, List<Article>>();
        json.put("articles", articles);
        String result = HttpUtil.doPost(UPLOADNEWS_URL.concat(accessToken), JSONObject.toJSONString(json));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return JSONObject.parseObject((String)result);
        }
        return null;
    }

    public static JSONObject massSendall(SendAllMsgTypes type, String content, String title, String description, String groupId, String[] openids, boolean toAll) throws InterruptedException, ExecutionException, IOException {
        String accessToken = WeiXinHelper.getAccessToken();
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        HashMap<String, String> body = new HashMap<String, String>();
        filter.put("is_to_all", false);
        json.put("msgtype", type.getType());
        if (toAll) {
            filter.put("is_to_all", true);
        } else if (StringUtils.isNotEmpty((CharSequence)groupId)) {
            filter.put("group_id", groupId);
        } else if (openids != null && openids.length > 0) {
            json.put("touser", openids);
        }
        switch (type) {
            case TEXT: {
                body.put("content", content);
                json.put("text", body);
                break;
            }
            case IMAGE: {
                body.put("media_id", content);
                json.put("image", body);
                break;
            }
            case VOICE: {
                body.put("media_id", content);
                json.put("voice", body);
                break;
            }
            case MPVIDEO: {
                body.put("media_id", content);
                json.put("mpvideo", body);
                break;
            }
            case MPNEWS: {
                body.put("media_id", content);
                json.put("mpnews", body);
                break;
            }
            case VIDEO: {
                body.put("media_id", content);
                body.put("title", title);
                body.put("description", description);
                json.put("video", body);
            }
        }
        String result = HttpUtil.doPost(MASS_SENDALL_URL.concat(accessToken), JSONObject.toJSONString(json));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return JSONObject.parseObject((String)result);
        }
        return null;
    }

    public static JSONObject massSend(String msgid) throws IOException, ExecutionException, InterruptedException {
        String accessToken = WeiXinHelper.getAccessToken();
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("msgid", msgid);
        String result = HttpUtil.doPost(MASS_DELETE_URL.concat(accessToken), JSONObject.toJSONString(json));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return JSONObject.parseObject((String)result);
        }
        return null;
    }

    public static JSONObject templateSend(TemplateData data) throws IOException, ExecutionException, InterruptedException {
        String accessToken = WeiXinHelper.getAccessToken();
        String result = HttpUtil.doPost(TEMPLATE_SEND_URL.concat(accessToken), JSONObject.toJSONString((Object)data));
        log.info("---------------------result:" + result);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return JSONObject.parseObject((String)result);
        }
        return null;
    }
}

