/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import com.alibaba.fastjson.JSON;
import com.zhlh.Tiny.util.CommonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    public static String keyPrefix = "redis";
    public static int timeOut = 3600;
    public static RedisTemplate<Serializable, Serializable> redisTemplate = new RedisTemplate();
    private static HashOperations<Serializable, Object, Object> hashOperations;

    public void init() {
        hashOperations = redisTemplate.opsForHash();
    }

    public static void put(String projectKey, Serializable objectTypeKey, Serializable objectKey, Object o) {
        RedisUtil.put(projectKey, objectTypeKey, objectKey, o, null);
    }

    public static void put(Serializable objectTypeKey, Serializable objectKey, Object o) {
        RedisUtil.put(null, objectTypeKey, objectKey, o, null);
    }

    public static void put(String projectKey, Serializable objectTypeKey, Serializable objectKey, Object o, Date expiry) {
        if (objectKey != null && o != null) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Put redis objectTypeKey is [%s],objectKey is [%s], value is [%s]", objectTypeKey, objectKey, o));
            }
            try {
                String jsonStr = JSON.toJSONString((Object)o);
                hashOperations.put((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), (Object)objectKey, (Object)jsonStr);
                if (expiry == null && timeOut != -1) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, timeOut);
                    expiry = calendar.getTime();
                }
                if (expiry != null) {
                    redisTemplate.expireAt((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), expiry);
                }
            }
            catch (Exception e) {
                log.error("RedisUtil.put error:", (Throwable)e);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("No redis put");
        }
    }

    public static void putAll(String projectKey, Serializable objectTypeKey, Map<? extends Object, ? extends Object> map) {
        RedisUtil.putAll(projectKey, objectTypeKey, map, null);
    }

    public static void putAll(Serializable objectTypeKey, Map<? extends Object, ? extends Object> map) {
        RedisUtil.putAll(null, objectTypeKey, map, null);
    }

    public static void putAll(String projectKey, Serializable objectTypeKey, Map<? extends Object, ? extends Object> map, Date expiry) {
        if (objectTypeKey != null && map != null) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Put redis objectTypeKey is [%s], value is [%s]", objectTypeKey, map));
            }
            try {
                HashMap<Object, String> inMap = new HashMap<Object, String>();
                for (Object object : map.keySet()) {
                    Object ob = map.get(object);
                    inMap.put(object, JSON.toJSONString((Object)ob));
                }
                hashOperations.putAll((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), inMap);
                if (expiry == null && timeOut != -1) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, timeOut);
                    expiry = calendar.getTime();
                }
                if (expiry != null) {
                    redisTemplate.expireAt((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), expiry);
                }
            }
            catch (Exception e) {
                log.error("RedisUtil.putAll error:", (Throwable)e);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("No redis put");
        }
    }

    public static <T> T get(Serializable objectTypeKey, Serializable objectKey, Class<T> c) {
        return RedisUtil.get(null, objectTypeKey, objectKey, c);
    }

    public static <T> T get(String projectKey, Serializable objectTypeKey, Serializable objectKey, Class<T> c) {
        Object returnO = null;
        if (objectKey != null) {
            try {
                Object o = hashOperations.get((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), (Object)objectKey);
                if (o != null) {
                    returnO = JSON.parseObject((String)((String)o), c);
                    if (log.isTraceEnabled()) {
                        log.trace(String.format("Get Put redis objectTypeKey is [%s],objectKey is [%s],value is [%s]", objectTypeKey, objectKey, returnO));
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace(String.format("Not find redis objectTypeKey is [%s],objectKey is [%s]", objectTypeKey, objectKey));
                }
            }
            catch (Exception e) {
                log.warn("RedisUtil.get error and will return null, but Does not affect the operation of the program. ", (Throwable)e);
            }
        }
        return (T)returnO;
    }

    public static <T> T getAll(Serializable objectTypeKey, Class beanClass) {
        return RedisUtil.getAll(null, objectTypeKey, beanClass);
    }

    public static <T> T getAll(String projectKey, Serializable objectTypeKey, Class beanClass) {
        ArrayList<Object> returnO = null;
        if (objectTypeKey != null) {
            try {
                List o = hashOperations.values((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey));
                if (o != null) {
                    ArrayList<Object> results = new ArrayList<Object>();
                    for (Object ob : o) {
                        String obStr = (String)ob;
                        results.add(JSON.parseObject((String)obStr, (Class)beanClass));
                    }
                    returnO = results;
                    if (log.isTraceEnabled()) {
                        log.trace(String.format("Get Put redis objectTypeKey is [%s],value is [%s]", objectTypeKey, returnO));
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace(String.format("Not find redis objectTypeKey is [%s]", objectTypeKey));
                }
            }
            catch (Exception e) {
                log.warn("RedisUtil.getAll error and will return null, but Does not affect the operation of the program. ", (Throwable)e);
            }
        }
        return (T)returnO;
    }

    public static void remove(Serializable objectTypeKey, Serializable objectKey) {
        RedisUtil.remove(null, objectTypeKey, objectKey);
    }

    public static void remove(String projectKey, Serializable objectTypeKey, Serializable objectKey) {
        if (objectKey != null) {
            hashOperations.delete((Object)RedisUtil.getFullObjectTypeKey(projectKey, objectTypeKey), new Object[]{objectKey});
        }
    }

    private static String getFullObjectTypeKey(String projectKey, Serializable objectTypeKey) {
        return CommonUtil.isEmpty(projectKey) ? keyPrefix + "_" + objectTypeKey : projectKey + "_" + objectTypeKey;
    }

    public static RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        return redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        RedisUtil.redisTemplate = redisTemplate;
    }

    public static String getKeyPrefix() {
        return keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        RedisUtil.keyPrefix = keyPrefix;
    }

    public static int getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(int timeOut) {
        RedisUtil.timeOut = timeOut;
    }
}

