/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil
extends FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static boolean deleteFile(File f) {
        if (f.isFile()) {
            f.delete();
        }
        return true;
    }

    public static boolean deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                FileUtil.deleteDir(files[i]);
            }
        }
        dir.delete();
        return true;
    }

    public static boolean deleteDir(String dir) {
        return FileUtil.deleteDir(new File(dir));
    }

    public static List getDirByNamePrefix(File dir, String namePrefix, String excludeDir) {
        ArrayList<File> dirList = new ArrayList<File>();
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory() || files[i].getName().equals(excludeDir) || !files[i].getName().startsWith(namePrefix)) continue;
                dirList.add(files[i]);
            }
        }
        return dirList;
    }

    public static boolean renameFile(File oldFile, String newFileName) {
        if (oldFile.isFile()) {
            oldFile.renameTo(new File(oldFile.getAbsolutePath().substring(0, oldFile.getAbsolutePath().lastIndexOf(File.separator) + 1) + newFileName));
        }
        return true;
    }

    public static boolean renameFile(String oldFile, String newFileName) {
        return FileUtil.renameFile(new File(oldFile), newFileName);
    }

    public static boolean renameDir(File oldDir, String newDirName) {
        if (oldDir.isDirectory()) {
            oldDir.renameTo(new File(oldDir.getAbsolutePath().substring(0, oldDir.getAbsolutePath().lastIndexOf(File.separator) + 1) + newDirName));
        }
        return true;
    }

    public static void copyFile(String srcFile, String targetFile) throws IOException {
        FileUtil.copyFile((File)new File(srcFile), (File)new File(targetFile));
    }

    public static void mkdirs(String outFilePath) {
        File file = new File(outFilePath);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static String fileNameAddSuffix(String fileName, String suffix) {
        int p = fileName.lastIndexOf(".");
        String fileName1 = fileName.substring(0, p);
        String extName = fileName.substring(p);
        return fileName1 + suffix + extName;
    }

    public static void writeStringToFile(String file, String data, String webencoding) throws IOException {
        FileUtil.writeStringToFile((File)new File(file), (String)data, (String)webencoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        StringBuffer str = null;
        if (fis != null) {
            FileChannel fc = fis.getChannel();
            ByteBuffer readBuffer = ByteBuffer.allocate(4096);
            try {
                str = new StringBuffer((int)fc.size());
                while (fc.read(readBuffer) != -1) {
                    readBuffer.flip();
                    str.append(Charset.forName("UTF-8").decode(readBuffer));
                    readBuffer.clear();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    fis.close();
                    fc.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return str == null ? null : str.toString();
    }

    public static String createFolder(String defaultPath, Integer dataId) throws Exception {
        String separator = System.getProperty("file.separator");
        StringBuffer sb = new StringBuffer(defaultPath);
        sb.append(dataId % 100);
        sb.append(separator);
        sb.append(dataId);
        sb.append(separator);
        sb.append(DateFormatUtils.format((Date)new Date(), (String)"yyMMdd"));
        sb.append(separator);
        try {
            File myFilePath = new File(sb.toString());
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
            return sb.toString().replace("\\", "/");
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void writeFile(InputStream inputStream, String target) throws IOException {
        File fileTarget = new File(target);
        File dir = fileTarget.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileTarget);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (outputStream == null) {
            logger.error("Write file " + target + "fail!");
            return;
        }
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.close();
    }

    public static boolean isEmptyDir(String path) {
        File d = new File(path);
        File[] list = d.listFiles();
        return list == null || list.length <= 0;
    }
}

