/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class PackageUtil {
    public static List<Class<?>> getAllClass(String pack) {
        ArrayList clazzs = new ArrayList();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageUtil.findClassInPackageByFile(packageName, filePath, recursive, clazzs);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazzs;
    }

    public static void findClassInPackageByFile(String packageName, String filePath, final boolean recursive, List<Class<?>> clazzs) {
        File[] dirFiles;
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean acceptDir = recursive && file.isDirectory();
                boolean acceptClass = file.getName().endsWith("class");
                return acceptDir || acceptClass;
            }
        })) {
            if (file.isDirectory()) {
                PackageUtil.findClassInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, clazzs);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                clazzs.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

