/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.wechat.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zhlh.Tiny.util.CommonUtil;
import com.zhlh.Tiny.util.HttpUtil;
import com.zhlh.Tiny.util.JsonUtil;
import com.zhlh.Tiny.wechat.helper.WeiXinHelper;
import com.zhlh.Tiny.wechat.model.QrReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinQrHelper {
    private static final Logger log = LoggerFactory.getLogger(WeiXinQrHelper.class);
    public static final String ACTION_NAME_QR_SCENE = "QR_SCENE";
    public static final String ACTION_NAME_QR_LIMIT_SCENE = "QR_LIMIT_SCENE";
    public static final String ACTION_NAME_QR_LIMIT_STR_SCENE = "QR_LIMIT_STR_SCENE";

    public static String getQr(String actionName, Integer sceneId, String sceneStr, Integer expireSeconds) {
        String ticket = WeiXinQrHelper.getTicket(actionName, sceneId, sceneStr, expireSeconds);
        return WeiXinQrHelper.getQrByTicketUrl(ticket);
    }

    public static String getQrFileString(String actionName, Integer sceneId, String sceneStr, Integer expireSeconds) {
        String ticket = WeiXinQrHelper.getTicket(actionName, sceneId, sceneStr, expireSeconds);
        return WeiXinQrHelper.getQrByTicket(ticket);
    }

    public static String getTicket(String actionName, Integer sceneId, String sceneStr, Integer expireSeconds) {
        QrReq qrReq = new QrReq();
        QrReq.ActionInfo actionInfo = new QrReq.ActionInfo(qrReq);
        QrReq.Scene scene = new QrReq.Scene(qrReq);
        qrReq.setAction_name(actionName);
        if (null != sceneId) {
            scene.setScene_id(sceneId);
        }
        if (CommonUtil.isNotEmpty(sceneStr)) {
            scene.setScene_str(sceneStr);
        }
        actionInfo.setScene(scene);
        qrReq.setAction_info(actionInfo);
        if (null != expireSeconds) {
            qrReq.setExpire_seconds(expireSeconds);
        }
        String jsonMsg = JsonUtil.beanToJSON(qrReq);
        String result = null;
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + WeiXinHelper.getAccessToken();
        String jsonResult = HttpUtil.doPost(requestUrl, jsonMsg);
        JSONObject jsonObject = JSON.parseObject((String)jsonResult);
        if (null != jsonObject && null != jsonObject.getString("ticket")) {
            String ticket = jsonObject.getString("ticket");
            log.info("ticket:" + ticket);
            result = ticket + "";
        }
        return result;
    }

    public static String getQrByTicket(String ticket) {
        String requestUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
        String jsonResult = HttpUtil.doGet(requestUrl);
        return jsonResult;
    }

    public static String getQrByTicketUrl(String ticket) {
        return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
    }
}

