/*
 * Decompiled with CFR 0.152.
 */
package com.zhlh.Tiny.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.CodeGenerationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.dozer.DozerBeanMapper;

public class BeanUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static DozerBeanMapper dozer = new DozerBeanMapper();
    private static final Map<Class<?>, Map<Class<?>, BeanCopier>> beanCopiers = new ConcurrentHashMap(128);

    public static Map<String, Method> getAllGetters(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        LinkedHashMap<String, Method> getters = new LinkedHashMap<String, Method>();
        for (Method m : methods) {
            if (m.getGenericParameterTypes().length != 0) continue;
            if (m.getName().startsWith("get")) {
                getters.put(BeanUtil.lowerFirstLetter(m.getName().substring(3)), m);
                continue;
            }
            if (!m.getName().startsWith("is") || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class) continue;
            getters.put(BeanUtil.lowerFirstLetter(m.getName().substring(2)), m);
        }
        return getters;
    }

    public static Map<String, Method> getAllSetters(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        LinkedHashMap<String, Method> setters = new LinkedHashMap<String, Method>();
        for (Method method : methods) {
            Method m = method;
            if (!m.getName().startsWith("set") || m.getGenericParameterTypes().length != 1 || m.getReturnType() != Void.TYPE) continue;
            String fieldName = BeanUtil.lowerFirstLetter(m.getName().substring(3));
            if (null != BeanUtil.getGetter(clazz, fieldName) && BeanUtil.getGetter(clazz, fieldName).getReturnType() != m.getGenericParameterTypes()[0]) {
                try {
                    m = clazz.getMethod(m.getName(), BeanUtil.getGetter(clazz, fieldName).getReturnType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            setters.put(fieldName, m);
        }
        return setters;
    }

    public static Method getGetter(Class<?> clazz, String fieldName) {
        return BeanUtil.getAllGetters(clazz).get(fieldName);
    }

    public static Method getSetter(Class<?> clazz, String fieldName) {
        return BeanUtil.getAllSetters(clazz).get(fieldName);
    }

    public static void invokeSetter(String fieldName, Object target, Object value) {
        Method setter = BeanUtil.getAllSetters(target.getClass()).get(fieldName);
        if (null == setter) {
            throw new RuntimeException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684setter\uff1a" + fieldName);
        }
        BeanUtil.invokeMethod(setter, target, value);
    }

    public static Object invokeGetter(String fieldName, Object target) {
        Method getter = BeanUtil.getAllGetters(target.getClass()).get(fieldName);
        if (null == getter) {
            throw new RuntimeException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684getter\uff1a" + fieldName);
        }
        return BeanUtil.invokeMethod(getter, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        if (null == method) {
            throw new RuntimeException("\u8c03\u7528\u76ee\u6807" + target + "\u7684\u65b9\u6cd5\u65f6\uff0cMethod\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return method.invoke(target, args);
        }
        catch (Exception var4) {
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T invokeNewInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception var2) {
            throw new RuntimeException("\u8be5\u5c5e\u6027\u6240\u5bf9\u5e94\u7684\u7c7b\u6ca1\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\uff0c" + clazz.toString());
        }
    }

    public static <T> T invokeNewInstance(Class<T> type, Class[] parameterTypes, Object[] args) {
        return (T)BeanUtil.invokeNewInstance(BeanUtil.getConstructor(type, parameterTypes), args);
    }

    public static Object invokeNewInstance(Constructor cstruct, Object[] args) {
        boolean flag = cstruct.isAccessible();
        try {
            Object result;
            cstruct.setAccessible(true);
            Object t = result = cstruct.newInstance(args);
            return t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CodeGenerationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
        finally {
            cstruct.setAccessible(flag);
        }
    }

    public static Constructor getConstructor(Class type, Class[] parameterTypes) {
        try {
            Constructor constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    private static String lowerFirstLetter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static void eachProperties(Object bean, EachPropertiesHandler eachPropertiesHandler) {
        BeanUtil.eachPropertiesInner(bean.getClass(), bean, eachPropertiesHandler);
    }

    public static Map<String, Object> objectToMap(Object bean, boolean isFilterBlank) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanUtil.beanToMapInner(bean.getClass(), bean, map, isFilterBlank);
        return map;
    }

    public static String beanToQueryString(Object bean, String dateFormat, String charset) {
        StringBuffer string = new StringBuffer();
        BeanUtil.beanToQueryStringInner(bean.getClass(), string, bean, dateFormat, charset);
        if (string.length() > 0) {
            string.delete(0, 1);
        }
        return string.toString();
    }

    public static String beanToQueryString(Object bean, String dateFormat) {
        return BeanUtil.beanToQueryString(bean, dateFormat, DEFAULT_CHARSET);
    }

    public static String beanToQueryString(Object bean) {
        return BeanUtil.beanToQueryString(bean, "yyyy-MM-dd", DEFAULT_CHARSET);
    }

    public static <T> T quickMap(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        BeanCopier beanCopier = BeanUtil.getBeanCopier(source.getClass(), targetClass);
        T to = null;
        try {
            to = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnsupportedOperationException("Class " + targetClass + "not hava constructor is no params", e);
        }
        beanCopier.copy(source, to, null);
        return to;
    }

    public static <T> List<T> quickMapList(Collection<?> sourceList, Class<T> targetClass) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (sourceList.isEmpty()) {
            return targetList;
        }
        Iterator<?> it = sourceList.iterator();
        BeanCopier beanCopier = BeanUtil.getBeanCopier(it.next().getClass(), targetClass);
        try {
            for (Object source : sourceList) {
                T target = targetClass.newInstance();
                beanCopier.copy(source, target, null);
                targetList.add(target);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Class " + targetClass + "not hava constructor is no params", e);
        }
        return targetList;
    }

    public static void quickCopy(Object source, Object target) {
        BeanUtil.notNull(source);
        BeanUtil.notNull(target);
        BeanCopier beanCopier = BeanUtil.getBeanCopier(source.getClass(), target.getClass());
        beanCopier.copy(source, target, null);
    }

    public static <T> T adviceMap(Object source, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        return (T)dozer.map(source, destinationClass);
    }

    public static <T> List<T> adviceMapList(Collection<?> sourceList, Class<T> destinationClass) {
        ArrayList<Object> destinationList = new ArrayList<Object>();
        for (Object sourceObject : sourceList) {
            Object destinationObject = dozer.map(sourceObject, destinationClass);
            destinationList.add(destinationObject);
        }
        return destinationList;
    }

    public static void adviceCopy(Object source, Object destinationObject) {
        BeanUtil.notNull(source);
        BeanUtil.notNull(destinationObject);
        dozer.map(source, destinationObject);
    }

    private static void beanToMapInner(Class<?> thisClass, Object bean, Map<String, Object> map, boolean isFilterBlank) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToMap(bean, map, method, 3, isFilterBlank);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToMap(bean, map, method, 2, isFilterBlank);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.beanToMapInner(superClass, bean, map, isFilterBlank);
        }
    }

    private static void pubValueToMap(Object bean, Map<String, Object> map, Method method, int methedNamePrefixLength, boolean isFilterBlank) {
        Object value = BeanUtil.invoke(bean, method);
        String methodName = method.getName();
        String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
        if (value != null) {
            map.put(fieldName, value);
        } else if (!isFilterBlank) {
            map.put(fieldName, "");
        }
    }

    private static void pubValueToString(Object bean, StringBuffer string, Method method, int methedNamePrefixLength, String dateFormat, String charset) {
        Object value = BeanUtil.invoke(bean, method);
        if (value != null) {
            boolean tag = true;
            if (Boolean.class.isInstance(value)) {
                tag = Boolean.TRUE.equals(value);
            }
            if (tag) {
                String methodName = method.getName();
                String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
                if (Date.class.isInstance(value)) {
                    value = DateFormatUtils.format((Date)((Date)value), (String)dateFormat);
                }
                try {
                    value = URLEncoder.encode(value + "", charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("unsupported encoding exception", e);
                }
                string.append("&").append(fieldName).append("=").append(value);
            }
        }
    }

    private static void beanToQueryStringInner(Class<?> thisClass, StringBuffer string, Object bean, String dateFormat, String charset) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToString(bean, string, method, 3, dateFormat, charset);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToString(bean, string, method, 2, dateFormat, charset);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.beanToQueryStringInner(superClass, string, bean, dateFormat, charset);
        }
    }

    private static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass) {
        Map<Class<?>, BeanCopier> mapInner = beanCopiers.get(sourceClass);
        BeanCopier beanCopier = null;
        if (mapInner == null) {
            mapInner = new ConcurrentHashMap(128);
            beanCopier = BeanCopier.create(sourceClass, targetClass, (boolean)false);
            mapInner.put(targetClass, beanCopier);
            beanCopiers.put(sourceClass, mapInner);
        } else {
            beanCopier = mapInner.get(targetClass);
            if (beanCopier == null) {
                beanCopier = BeanCopier.create(sourceClass, targetClass, (boolean)false);
                mapInner.put(targetClass, beanCopier);
            }
        }
        return beanCopier;
    }

    private static void eachPropertiesInner(Class<?> thisClass, Object bean, EachPropertiesHandler eachPropertiesHandler) {
        Method[] methods;
        for (Method method : methods = thisClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                BeanUtil.pubValueToHandler(bean, method, 3, eachPropertiesHandler);
                continue;
            }
            if (methodName.length() <= 2 || !methodName.startsWith("is")) continue;
            BeanUtil.pubValueToHandler(bean, method, 2, eachPropertiesHandler);
        }
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BeanUtil.eachPropertiesInner(superClass, bean, eachPropertiesHandler);
        }
    }

    private static void pubValueToHandler(Object bean, Method method, int methedNamePrefixLength, EachPropertiesHandler eachPropertiesHandler) {
        Object value = BeanUtil.invoke(bean, method);
        if (value != null) {
            String methodName = method.getName();
            String fieldName = StringUtils.uncapitalize((String)StringUtils.substring((String)methodName, (int)methedNamePrefixLength));
            eachPropertiesHandler.handler(bean, fieldName, value);
        }
    }

    private static Object invoke(Object bean, Method method) {
        Object value = null;
        try {
            value = method.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e.getTargetException().getMessage(), e);
        }
        return value;
    }

    private static void notNull(Object object) {
        BeanUtil.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void setFieldDefaultValue(Object object, Object defaultValue) {
        try {
            Field[] declaredFields = object.getClass().getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field f = declaredFields[i];
                f.setAccessible(true);
                Object val = f.get(object);
                String type = f.getType().toString();
                if (!type.endsWith("String") || val != null) continue;
                f.set(object, defaultValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface EachPropertiesHandler {
        public void handler(Object var1, String var2, Object var3);
    }
}

